/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.security.rules.model.type;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.osivia.procedures.record.security.rules.model.relation.RecordsRelation;
import org.osivia.procedures.record.security.rules.model.type.RecordModel;

public class Entity {
    private String type;
    private boolean isSecurity;
    private RecordModel recordModel;
    private RecordsRelation relationTo;
    private RecordsRelation relationFrom;
    private boolean fetched;
    private List<String> ids;
    private List<DocumentModel> records;

    public Entity(RecordModel recordModel) {
        this.recordModel = recordModel;
    }

    public Entity(String type) {
        this.type = type;
        this.records = new ArrayList<DocumentModel>();
    }

    public RecordModel getRecordModel() {
        return this.recordModel;
    }

    public void setRecordModel(RecordModel recordModel) {
        this.recordModel = recordModel;
    }

    public void addRecord(DocumentModel record) {
        this.records.add(record);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isSecurity() {
        return this.isSecurity;
    }

    public void setSecurity(boolean isSecurity) {
        this.isSecurity = isSecurity;
    }

    public RecordsRelation getRelationTo() {
        return this.relationTo;
    }

    public void setRelationTo(RecordsRelation relationTo) {
        this.relationTo = relationTo;
    }

    public RecordsRelation getRelationFrom() {
        return this.relationFrom;
    }

    public void setRelationFrom(RecordsRelation relationFrom) {
        this.relationFrom = relationFrom;
    }

    public boolean isFetched() {
        return this.fetched;
    }

    public void setFetched(boolean fetched) {
        this.fetched = fetched;
    }

    public List<DocumentModel> getRecords() {
        return this.records;
    }

    public void setRecords(List<DocumentModel> records) {
        this.records = records;
    }

    public List<String> getIds() {
        if (this.ids == null && this.records != null) {
            this.ids = new ArrayList<String>(this.records.size());
            for (DocumentModel record : this.records) {
                this.ids.add((String)record.getProperty("ttc:webid").getValue(String.class));
            }
        }
        return this.ids;
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public boolean equals(Object other) {
        boolean equals = false;
        if (other != null && other instanceof Entity) {
            Entity otherEntity = (Entity)other;
            equals = StringUtils.equals((CharSequence)this.type, (CharSequence)otherEntity.getType());
        }
        return equals;
    }
}

