/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.cas2;

import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import edu.yale.its.tp.cas.client.ServiceTicketValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.LoginResponseHandler;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPluginLogoutExtension;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;
import org.xml.sax.SAXException;

public class Cas2Authenticator
implements NuxeoAuthenticationPlugin,
NuxeoAuthenticationPluginLogoutExtension,
LoginResponseHandler {
    protected static final String CAS_SERVER_HEADER_KEY = "CasServer";
    protected static final String CAS_SERVER_PATTERN_KEY = "$CASSERVER";
    protected static final String NUXEO_SERVER_PATTERN_KEY = "$NUXEO";
    protected static final String LOGIN_ACTION = "Login";
    protected static final String LOGOUT_ACTION = "Logout";
    protected static final String VALIDATE_ACTION = "Valid";
    protected static final String PROXY_VALIDATE_ACTION = "ProxyValid";
    protected static final Log log = LogFactory.getLog(Cas2Authenticator.class);
    protected static final String EXCLUDE_PROMPT_KEY = "excludePromptURL";
    protected static final String ALTERNATIVE_AUTH_PLUGIN_COOKIE_NAME = "org.nuxeo.auth.plugin.alternative";
    protected String ticketKey = "ticket";
    protected String proxyKey = "proxy";
    protected String appURL = "http://127.0.0.1:8080/nuxeo/";
    protected String serviceLoginURL = "http://127.0.0.1:8080/cas/login";
    protected String serviceValidateURL = "http://127.0.0.1:8080/cas/serviceValidate";
    protected String proxyValidateURL = "http://127.0.0.1:8080/cas/proxyValidate";
    protected String serviceKey = "service";
    protected String logoutURL = "";
    protected String defaultCasServer = "";
    protected String ticketValidatorClassName = "edu.yale.its.tp.cas.client.ServiceTicketValidator";
    protected String proxyValidatorClassName = "edu.yale.its.tp.cas.client.ProxyTicketValidator";
    protected boolean promptLogin = true;
    protected List<String> excludePromptURLs;
    protected String errorPage;

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    protected String getServiceURL(HttpServletRequest httpRequest, String action) {
        String url = "";
        if (action.equals(LOGIN_ACTION)) {
            url = this.serviceLoginURL;
        } else if (action.equals(LOGOUT_ACTION)) {
            url = this.logoutURL;
        } else if (action.equals(VALIDATE_ACTION)) {
            url = this.serviceValidateURL;
        } else if (action.equals(PROXY_VALIDATE_ACTION)) {
            url = this.proxyValidateURL;
        }
        if (url.contains(CAS_SERVER_PATTERN_KEY)) {
            String serverURL = httpRequest.getHeader(CAS_SERVER_HEADER_KEY);
            if (serverURL != null) {
                url = url.replace(CAS_SERVER_PATTERN_KEY, serverURL);
            } else if (url.contains(CAS_SERVER_PATTERN_KEY)) {
                url = url.replace(CAS_SERVER_PATTERN_KEY, this.defaultCasServer);
            }
        }
        log.debug((Object)("serviceUrl: " + url));
        return url;
    }

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        NuxeoAuthenticationPlugin alternativeAuthPlugin = this.getAlternativeAuthPlugin(httpRequest, httpResponse);
        if (alternativeAuthPlugin != null) {
            log.debug((Object)String.format("Found alternative authentication plugin %s, using it to handle login prompt.", alternativeAuthPlugin));
            return alternativeAuthPlugin.handleLoginPrompt(httpRequest, httpResponse, baseURL);
        }
        String location = null;
        try {
            HashMap<String, String> urlParameters = new HashMap<String, String>();
            urlParameters.put("service", this.getAppURL(httpRequest));
            location = URIUtils.addParametersToURIQuery((String)this.getServiceURL(httpRequest, LOGIN_ACTION), urlParameters);
            httpResponse.sendRedirect(location);
        }
        catch (IOException e) {
            log.error((Object)("Unable to redirect to CAS login screen to " + location), (Throwable)e);
            return false;
        }
        return true;
    }

    protected String getAppURL(HttpServletRequest httpRequest) {
        if (this.isValidStartupPage(httpRequest)) {
            StringBuffer sb = new StringBuffer(VirtualHostHelper.getServerURL((ServletRequest)httpRequest));
            if (VirtualHostHelper.getServerURL((ServletRequest)httpRequest).endsWith("/")) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append(httpRequest.getRequestURI());
            if (httpRequest.getQueryString() != null) {
                sb.append("?");
                sb.append(httpRequest.getQueryString());
                int indexTicketKey = sb.lastIndexOf(this.ticketKey + "=");
                if (indexTicketKey != -1) {
                    sb.delete(indexTicketKey - 1, sb.length());
                }
            }
            return sb.toString();
        }
        if (this.appURL == null || this.appURL.equals("")) {
            this.appURL = NUXEO_SERVER_PATTERN_KEY;
        }
        if (this.appURL.contains(NUXEO_SERVER_PATTERN_KEY)) {
            String nxurl = BaseURL.getBaseURL((ServletRequest)httpRequest);
            return this.appURL.replace(NUXEO_SERVER_PATTERN_KEY, nxurl);
        }
        return this.appURL;
    }

    private boolean isValidStartupPage(HttpServletRequest httpRequest) {
        if (httpRequest.getRequestURI() == null) {
            return false;
        }
        PluggableAuthenticationService service = (PluggableAuthenticationService)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService");
        if (service == null) {
            return false;
        }
        String startPage = httpRequest.getRequestURI().replace(VirtualHostHelper.getContextPath((ServletRequest)httpRequest) + "/", "");
        for (String prefix : service.getStartURLPatterns()) {
            if (!startPage.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String casTicket = httpRequest.getParameter(this.ticketKey);
        String proxy = httpRequest.getParameter(this.proxyKey);
        if (casTicket == null) {
            log.debug((Object)"No ticket found");
            return null;
        }
        String userName = proxy == null ? this.checkCasTicket(casTicket, httpRequest) : this.checkProxyCasTicket(casTicket, httpRequest);
        if (userName == null) {
            return null;
        }
        UserIdentificationInfo uui = new UserIdentificationInfo(userName, casTicket);
        uui.setToken(casTicket);
        return uui;
    }

    public void initPlugin(Map<String, String> parameters) {
        if (parameters.containsKey("ticketKey")) {
            this.ticketKey = parameters.get("ticketKey");
        }
        if (parameters.containsKey("proxyKey")) {
            this.proxyKey = parameters.get("proxyKey");
        }
        if (parameters.containsKey("appURL")) {
            this.appURL = parameters.get("appURL");
        }
        if (parameters.containsKey("serviceLoginURL")) {
            this.serviceLoginURL = parameters.get("serviceLoginURL");
        }
        if (parameters.containsKey("serviceValidateURL")) {
            this.serviceValidateURL = parameters.get("serviceValidateURL");
        }
        if (parameters.containsKey("proxyValidateURL")) {
            this.proxyValidateURL = parameters.get("proxyValidateURL");
        }
        if (parameters.containsKey("serviceKey")) {
            this.serviceKey = parameters.get("serviceKey");
        }
        if (parameters.containsKey("logoutURL")) {
            this.logoutURL = parameters.get("logoutURL");
        }
        if (parameters.containsKey("defaultCasServer")) {
            this.defaultCasServer = parameters.get("defaultCasServer");
        }
        if (parameters.containsKey("serviceValidatorClass")) {
            this.ticketValidatorClassName = parameters.get("serviceValidatorClass");
        }
        if (parameters.containsKey("proxyValidatorClass")) {
            this.proxyValidatorClassName = parameters.get("proxyValidatorClass");
        }
        if (parameters.containsKey("promptLogin")) {
            this.promptLogin = Boolean.parseBoolean(parameters.get("promptLogin"));
        }
        this.excludePromptURLs = new ArrayList<String>();
        for (String key : parameters.keySet()) {
            if (!key.startsWith(EXCLUDE_PROMPT_KEY)) continue;
            this.excludePromptURLs.add(parameters.get(key));
        }
        if (parameters.containsKey("errorPage")) {
            this.errorPage = parameters.get("errorPage");
        }
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        String requestedURI = httpRequest.getRequestURI();
        String context = httpRequest.getContextPath() + '/';
        requestedURI = requestedURI.substring(context.length());
        for (String prefixURL : this.excludePromptURLs) {
            if (!requestedURI.startsWith(prefixURL)) continue;
            return false;
        }
        return this.promptLogin;
    }

    public Boolean handleLogout(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        NuxeoAuthenticationPlugin alternativeAuthPlugin = this.getAlternativeAuthPlugin(httpRequest, httpResponse);
        if (alternativeAuthPlugin != null) {
            if (alternativeAuthPlugin instanceof NuxeoAuthenticationPluginLogoutExtension) {
                log.debug((Object)String.format("Found alternative authentication plugin %s, using it to handle logout.", alternativeAuthPlugin));
                return ((NuxeoAuthenticationPluginLogoutExtension)alternativeAuthPlugin).handleLogout(httpRequest, httpResponse);
            }
            log.debug((Object)String.format("Found alternative authentication plugin %s which cannot handle logout, letting authentication filter handle it.", alternativeAuthPlugin));
            return false;
        }
        if (this.logoutURL == null || this.logoutURL.equals("")) {
            log.debug((Object)"No CAS logout params, skipping CAS2Logout");
            return false;
        }
        try {
            httpResponse.sendRedirect(this.getServiceURL(httpRequest, LOGOUT_ACTION));
        }
        catch (IOException e) {
            log.error((Object)"Unable to redirect to CAS logout screen:", (Throwable)e);
            return false;
        }
        return true;
    }

    protected String checkProxyCasTicket(String ticket, HttpServletRequest httpRequest) {
        ProxyTicketValidator proxyValidator;
        String service = httpRequest.getParameter(this.serviceKey);
        if (service == null) {
            log.error((Object)"checkProxyCasTicket: no service name in the URL");
            return null;
        }
        try {
            proxyValidator = (ProxyTicketValidator)Framework.getRuntime().getContext().loadClass(this.proxyValidatorClassName).newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)"checkProxyCasTicket during the ProxyTicketValidator initialization with InstantiationException:", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            log.error((Object)"checkProxyCasTicket during the ProxyTicketValidator initialization with IllegalAccessException:", (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"checkProxyCasTicket during the ProxyTicketValidator initialization with ClassNotFoundException:", (Throwable)e);
            return null;
        }
        proxyValidator.setCasValidateUrl(this.getServiceURL(httpRequest, PROXY_VALIDATE_ACTION));
        proxyValidator.setService(service);
        proxyValidator.setServiceTicket(ticket);
        try {
            proxyValidator.validate();
        }
        catch (IOException e) {
            log.error((Object)"checkProxyCasTicket failed with IOException:", (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            log.error((Object)"checkProxyCasTicket failed with SAXException:", (Throwable)e);
            return null;
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"checkProxyCasTicket failed with ParserConfigurationException:", (Throwable)e);
            return null;
        }
        log.debug((Object)"checkProxyCasTicket: validation executed without error");
        String username = proxyValidator.getUser();
        log.debug((Object)("checkProxyCasTicket: validation returned username = " + username));
        return username;
    }

    protected String checkCasTicket(String ticket, HttpServletRequest httpRequest) {
        ServiceTicketValidator ticketValidator;
        try {
            ticketValidator = (ServiceTicketValidator)Framework.getRuntime().getContext().loadClass(this.ticketValidatorClassName).newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)"checkCasTicket during the ServiceTicketValidator initialization with InstantiationException:", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            log.error((Object)"checkCasTicket during the ServiceTicketValidator initialization with IllegalAccessException:", (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"checkCasTicket during the ServiceTicketValidator initialization with ClassNotFoundException:", (Throwable)e);
            return null;
        }
        ticketValidator.setCasValidateUrl(this.getServiceURL(httpRequest, VALIDATE_ACTION));
        ticketValidator.setService(this.getAppURL(httpRequest));
        ticketValidator.setServiceTicket(ticket);
        try {
            ticketValidator.validate();
        }
        catch (IOException e) {
            log.error((Object)"checkCasTicket failed with IOException:", (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            log.error((Object)"checkCasTicket failed with SAXException:", (Throwable)e);
            return null;
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"checkCasTicket failed with ParserConfigurationException:", (Throwable)e);
            return null;
        }
        log.debug((Object)"checkCasTicket : validation executed without error");
        String username = ticketValidator.getUser();
        log.debug((Object)("checkCasTicket: validation returned username = " + username));
        return username;
    }

    public boolean onError(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setStatus(401);
            if (this.errorPage != null) {
                response.sendRedirect(this.errorPage);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    public boolean onSuccess(HttpServletRequest arg0, HttpServletResponse arg1) {
        return false;
    }

    protected NuxeoAuthenticationPlugin getAlternativeAuthPlugin(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        Cookie alternativeAuthPluginCookie = this.getCookie(httpRequest, ALTERNATIVE_AUTH_PLUGIN_COOKIE_NAME);
        if (alternativeAuthPluginCookie != null) {
            String alternativeAuthPluginName = alternativeAuthPluginCookie.getValue();
            PluggableAuthenticationService authService = (PluggableAuthenticationService)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService");
            NuxeoAuthenticationPlugin alternativeAuthPlugin = authService.getPlugin(alternativeAuthPluginName);
            if (alternativeAuthPlugin == null) {
                log.error((Object)String.format("No alternative authentication plugin named %s, will remove cookie %s.", alternativeAuthPluginName, ALTERNATIVE_AUTH_PLUGIN_COOKIE_NAME));
                this.removeCookie(httpRequest, httpResponse, alternativeAuthPluginCookie);
            } else {
                return alternativeAuthPlugin;
            }
        }
        return null;
    }

    protected Cookie getCookie(HttpServletRequest httpRequest, String cookieName) {
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookieName.equals(cookies[i].getName())) continue;
                return cookies[i];
            }
        }
        return null;
    }

    protected void removeCookie(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Cookie cookie) {
        log.debug((Object)String.format("Removing cookie %s.", cookie.getName()));
        cookie.setMaxAge(0);
        cookie.setValue("");
        cookie.setPath(httpRequest.getContextPath());
        httpResponse.addCookie(cookie);
    }
}

