/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.mode.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import fr.toutatice.ecm.platform.web.mode.service.SegmentService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class BulkSetSegmentsListener
implements PostCommitEventListener {
    public static final String LIVES_CHILDREN = "select * from Document where ecm:parentId = '%s' and ecm:isVersion = 0 and ecm:isProxy = 0 and ecm:currentLifeCycleState <> 'deleted'";
    public static final String LEAFS_WITH_SEGMENTS = "select * from Document where ecm:ancestorId = '%s' and ecm:mixinType = '%s' and ecm:isVersion = 0 and ecm:isProxy = 0 and ecm:currentLifeCycleState <> 'deleted'";

    public void handleEvent(EventBundle events) throws ClientException {
        for (Event event : events) {
            Boolean webUrlsEnabled;
            EventContext eventContext;
            if (!"beforeDocumentModification".equals(event.getName()) || !((eventContext = event.getContext()) instanceof DocumentEventContext)) continue;
            DocumentModel sourceDocument = ((DocumentEventContext)eventContext).getSourceDocument();
            CoreSession session = sourceDocument.getCoreSession();
            if (!"PortalSite".equals(sourceDocument.getType()) || !BooleanUtils.isTrue((Boolean)(webUrlsEnabled = (Boolean)sourceDocument.getPropertyValue("ottcwebc:enableWebUrl")))) continue;
            SegmentService segmentService = (SegmentService)((Object)Framework.getService(SegmentService.class));
            DocumentModelListImpl authorizedDocs = new DocumentModelListImpl();
            authorizedDocs.add((Object)sourceDocument);
            DocumentModel domain = ToutaticeDocumentHelper.getDomain((CoreSession)session, (DocumentModel)sourceDocument, (boolean)true);
            if (domain != null) {
                String leafQuery = String.format(LEAFS_WITH_SEGMENTS, domain.getId(), "hasWebUrl");
                DocumentModelList leafsDocuments = session.query(leafQuery);
                if (CollectionUtils.isNotEmpty((Collection)leafsDocuments)) {
                    authorizedDocs.addAll((Collection)leafsDocuments);
                }
                for (DocumentModel doc : authorizedDocs) {
                    if (!segmentService.supportsWebUrls(session, doc)) continue;
                    this.setSegments(session, segmentService, doc);
                }
                session.save();
                continue;
            }
            if (sourceDocument == null) continue;
            throw new ClientException(String.format("No Domain found from document [%s] ", sourceDocument.getPathAsString()));
        }
    }

    private void setSegments(CoreSession session, SegmentService segmentService, DocumentModel document) {
        String segment = (String)((Object)document.getPropertyValue("ottcweb:segment"));
        if (StringUtils.isBlank((String)segment)) {
            this.generateSegment(session, segmentService, document);
        }
        if (session.hasChildren(document.getRef())) {
            DocumentModelList children = session.query(String.format(LIVES_CHILDREN, document.getId()));
            for (DocumentModel child : children) {
                this.setSegments(session, segmentService, child);
            }
        }
    }

    private void generateSegment(CoreSession session, SegmentService segmentService, DocumentModel document) {
        String segment = segmentService.createSegment(session, document);
        document.setPropertyValue("ottcweb:segment", (Serializable)((Object)segment));
        ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)session, (DocumentModel)document, (boolean)true);
        DocumentModel localProxy = ToutaticeDocumentHelper.getProxy((CoreSession)session, (DocumentModel)document, null);
        if (localProxy != null) {
            DocumentModel version = session.getSourceDocument(localProxy.getRef());
            version.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
            version.setPropertyValue("ottcweb:segment", (Serializable)((Object)segment));
            ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)session, (DocumentModel)version, (List)ToutaticeSilentProcessRunnerHelper.DEFAULT_FILTERED_SERVICES_LIST, (boolean)true);
        }
    }
}

