/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.addon.shortname.automation;

import fr.toutatice.ecm.acrennes.addon.shortname.service.ShortNameMgtService;
import fr.toutatice.ecm.platform.core.helper.ToutaticeOperationHelper;
import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

@Operation(id="Document.GetLDAPRolePattern", category="Document", label="Get the pattern to build the LDAP roles", description="Get the pattern to build the LDAP roles. Returns a JSON object like : {\"identifier\" : \"doc-shortname\", \"pattern\" : \"struct_doc-shortname_%s\"}")
public class GetLDAPRolePattern {
    public static final String ID = "Document.GetLDAPRolePattern";
    private static final Log log = LogFactory.getLog(GetLDAPRolePattern.class);
    @Context
    protected CoreSession session;
    @Context
    protected ShortNameMgtService snService;

    @OperationMethod
    public Blob run(DocumentModel document) throws OperationException {
        StringBlob pattern = null;
        try {
            String shortName = (String)((Object)document.getPropertyValue("acr:shortName"));
            if (StringUtils.isBlank((String)shortName)) {
                OperationContext ctxt = new OperationContext(this.session);
                ctxt.setInput((Object)document);
                HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
                parameters.put("Override", true);
                document = (DocumentModel)ToutaticeOperationHelper.callOperation((OperationContext)ctxt, (String)"Document.SetDocumentShortName", parameters);
            }
            String rule = this.snService.getGroupeNamingRule(document, null);
            String identifier = this.snService.getIdentifier(document, null);
            log.info((Object)("Get the LDAP roles pattern '" + rule + "' (identifier=" + identifier + ") of the document '" + document.getPathAsString() + "'"));
            JSONObject jso = new JSONObject();
            if (rule != null) {
                jso.element("pattern", (Object)(rule + "%s")).element("identifier", (Object)identifier);
            }
            pattern = new StringBlob(jso.toString(), "application/json");
        }
        catch (ToutaticeException e) {
            throw new OperationException((Throwable)e);
        }
        return pattern;
    }

    @OperationMethod
    public Blob run(DocumentRef documentRef) throws OperationException, ClientException {
        return this.run(this.session.getDocument(documentRef));
    }
}

