/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.addon.shortname.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.ecm.platform.uidgen.service.ServiceHelper;
import org.nuxeo.ecm.platform.uidgen.service.UIDGeneratorService;

@Operation(id="Document.SetDocumentShortName", category="Document", label="Set a document's short name", description="Set the short name metadata of a document if the document is intended to own one. If the document is intended to own one but it is not filled yet, compute this data and set it on the document. Return the updated document.")
public class SetDocumentShortName {
    public static final String ID = "Document.SetDocumentShortName";
    private static final Log log = LogFactory.getLog(SetDocumentShortName.class);
    private static final List<Class<?>> FILTERED_SERVICES_LIST = new ArrayList<Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(EventService.class);
            this.add(VersioningService.class);
        }
    };
    @Context
    protected CoreSession session;
    @Param(name="Override", required=false)
    protected boolean override = false;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel document) throws OperationException {
        if (document.isImmutable()) {
            throw new OperationException("The document is immutable");
        }
        if (document.hasSchema("acaren")) {
            try {
                String shortName = (String)((Object)document.getPropertyValue("acr:shortName"));
                if (StringUtils.isBlank((String)shortName) || this.override) {
                    document = this.SetShortNameProperty(document);
                    log.info((Object)("shortName is set for the document '" + document.getPathAsString() + "'"));
                }
                log.warn((Object)("Not allowed to override the existing shortName of the document '" + document.getPathAsString() + "'"));
            }
            catch (Exception e) {
                throw new OperationException((Throwable)e);
            }
        } else {
            throw new OperationException("The document is not intended to own this meta-data");
        }
        return document;
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef documentRef) throws OperationException {
        return this.run(this.session.getDocument(documentRef));
    }

    private DocumentModel SetShortNameProperty(DocumentModel document) throws DocumentException {
        DocumentModel updatedDoc = document;
        UpdateDocumentRunner runner = new UpdateDocumentRunner(this.session, document);
        runner.silentRun(true, FILTERED_SERVICES_LIST);
        updatedDoc = runner.getDocument();
        return updatedDoc;
    }

    private class UpdateDocumentRunner
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel document;

        public UpdateDocumentRunner(CoreSession session, DocumentModel document) {
            super(session);
            this.document = document;
        }

        public void run() throws ClientException {
            try {
                UIDGeneratorService generatorService = ServiceHelper.getUIDGeneratorService();
                generatorService.setUID(this.document);
                this.session.saveDocument(this.document);
            }
            catch (DocumentException e) {
                throw new ClientException("Faild to generate shortname, error: " + e.getLocalizedMessage());
            }
        }

        public DocumentModel getDocument() throws ClientException {
            return this.session.getDocument(this.document.getRef());
        }
    }
}

