/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.notification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ec.notification.UserSubscription;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.ec.placeful.Annotation;
import org.nuxeo.ecm.platform.ec.placeful.interfaces.PlacefulService;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;

@Name(value="userNotificationActions")
@Scope(value=ScopeType.CONVERSATION)
public class UserNotificationActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected NuxeoPrincipal currentUser;
    @In(create=true)
    protected CoreSession documentManager;
    @In(create=true)
    protected transient NotificationManager notificationManager;
    private List<UserSubscription> subscriptions;

    @Factory(value="userSubscriptions", scope=ScopeType.EVENT)
    public List<UserSubscription> getUserSubscriptions() throws ClientException {
        PlacefulService service;
        try {
            service = NotificationServiceHelper.getPlacefulService();
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        String className = (String)service.getAnnotationRegistry().get("UserSubscription");
        String shortClassName = className.substring(className.lastIndexOf(46) + 1);
        PlacefulService serviceBean = NotificationServiceHelper.getPlacefulServiceBean();
        ArrayList<Annotation> tempSubscriptions = new ArrayList<Annotation>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userId", "user:" + this.currentUser.getName());
        tempSubscriptions.addAll(serviceBean.getAnnotationListByParamMap(paramMap, shortClassName));
        for (String group : this.currentUser.getAllGroups()) {
            paramMap.put("userId", "group:" + group);
            tempSubscriptions.addAll(serviceBean.getAnnotationListByParamMap(paramMap, shortClassName));
        }
        this.reorderSubscriptions(tempSubscriptions);
        return this.subscriptions;
    }

    private void reorderSubscriptions(List<Annotation> allSubscriptions) throws ClientException {
        HashMap unsortedSubscriptions = new HashMap();
        for (Annotation obj : allSubscriptions) {
            UserSubscription us = (UserSubscription)obj;
            DocumentModel doc = this.getDocument(us.getDocId());
            String path = doc == null ? us.getDocId() : this.getDocument(us.getDocId()).getPathAsString();
            if (!unsortedSubscriptions.containsKey(path)) {
                unsortedSubscriptions.put(path, new ArrayList());
            }
            ((List)unsortedSubscriptions.get(path)).add(us);
        }
        TreeSet sortedset = new TreeSet(unsortedSubscriptions.keySet());
        this.subscriptions = new ArrayList<UserSubscription>();
        Iterator it = sortedset.iterator();
        while (it.hasNext()) {
            this.subscriptions.addAll((Collection)unsortedSubscriptions.get(it.next()));
        }
    }

    public DocumentModel getDocument(String docId) throws ClientException {
        IdRef ref = new IdRef(docId);
        if (this.documentManager.exists((DocumentRef)ref)) {
            return this.documentManager.getDocument((DocumentRef)ref);
        }
        return null;
    }

    public boolean getCanRemoveNotification(String userId) {
        return userId != null && userId.equals("user:" + this.currentUser.getName());
    }
}

