/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.uar.ecm.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeOperationHelper;
import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class UAREventListener
implements EventListener {
    private static final String OPERATION_CHAIN_NAME = "uar-maj-demande-impression";
    private static final String UAR_DEMANDE_IMPRESSION_DOC_TYPE = "uar-demande-impression";
    private static final Log log = LogFactory.getLog(UAREventListener.class);

    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext eventContext;
        DocumentModel doc;
        if (event.getContext() instanceof DocumentEventContext && UAR_DEMANDE_IMPRESSION_DOC_TYPE.equals((doc = (eventContext = (DocumentEventContext)event.getContext()).getSourceDocument()).getType())) {
            if (doc.isImmutable()) {
                return;
            }
            try {
                ToutaticeOperationHelper.runOperationChain((CoreSession)eventContext.getCoreSession(), (String)OPERATION_CHAIN_NAME, (Object)doc);
            }
            catch (ToutaticeException e) {
                log.info((Object)("Failed to execute the operation chain 'uar-maj-demande-impression', error: " + e.getCause().getMessage()));
                FacesMessages.instance().add(StatusMessage.Severity.WARN, e.getCause().getMessage(), new Object[]{new Object()});
            }
        }
    }
}

