/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.uar.ecm.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDirectoryMngtHelper;
import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class UAREventListener_EmptyDocumentCreated
implements EventListener {
    private static final String UAR_DEMANDE_IMPRESSION_DOC_TYPE = "uar-demande-impression";
    private static final String PARENT_PATH = "parentPath";
    private static final Log log = LogFactory.getLog(UAREventListener_EmptyDocumentCreated.class);

    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext eventContext;
        DocumentModel doc;
        if (event.getContext() instanceof DocumentEventContext && UAR_DEMANDE_IMPRESSION_DOC_TYPE.equals((doc = (eventContext = (DocumentEventContext)event.getContext()).getSourceDocument()).getType())) {
            String etablissement;
            if (doc.isImmutable()) {
                return;
            }
            String parentPath = (String)((Object)eventContext.getProperty(PARENT_PATH));
            if (null == parentPath) {
                return;
            }
            CoreSession session = eventContext.getCoreSession();
            DocumentModel parent = session.getDocument((DocumentRef)new PathRef(parentPath));
            doc.setPropertyValue("uar:division", (Serializable)((Object)parent.getTitle()));
            NuxeoPrincipal currentUser = (NuxeoPrincipal)session.getPrincipal();
            String rne = currentUser.getCompany();
            try {
                etablissement = ToutaticeDirectoryMngtHelper.instance().getDirectoryEntryLabel("uar-rne-etab", rne);
            }
            catch (ToutaticeException e) {
                etablissement = "";
                log.warn((Object)(" Impossible de trouver l'\u00e9tablissement de l'utilisateur : " + e.getMessage()));
            }
            doc.setPropertyValue("uar:etablissement", (Serializable)((Object)etablissement));
        }
    }
}

