/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.mee.ecm.automation;

import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.In;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.relations.api.DocumentRelationManager;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.exceptions.RelationAlreadyExistsException;
import org.nuxeo.ecm.platform.relations.api.impl.QNameResourceImpl;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Operation(id="Document.GetOutgoingRelations", category="Document", label="Add relation", description="Add relation")
public class AddMeeRelation {
    private static final Log log = LogFactory.getLog(AddMeeRelation.class);
    public static final String ID = "Document.addMeeRelation";
    private static final String PREDICATE_URI = "http://purl.org/dc/terms/References";
    private static final String COMMENT = "relation mee";
    private static final String MIME_JSON = "application/json";
    @In(create=true)
    protected DocumentRelationManager docRelationManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @Context
    protected CoreSession session;
    @Param(name="idObject")
    protected String idObject;

    @OperationMethod
    public Object run(DocumentModel input) throws Exception {
        String res;
        try {
            this.idObject = this.idObject.trim();
            String repositoryName = this.navigationContext.getCurrentServerLocation().getName();
            String localName = repositoryName + "/" + this.idObject;
            QNameResourceImpl object = new QNameResourceImpl("http://www.nuxeo.org/document/uid/", localName);
            this.docRelationManager.addRelation(this.session, input, (Node)object, PREDICATE_URI, false, false, COMMENT);
            res = "OK";
        }
        catch (RelationAlreadyExistsException e) {
            res = "EXIST";
            log.info((Object)("La relation mee entre " + input.getTitle() + " et le document id " + this.idObject + " existe d\u00e9j\u00e0."));
        }
        catch (Exception e) {
            res = "KO";
            log.error((Object)(" *** " + e.getMessage()));
        }
        JSONObject jso = new JSONObject();
        if (StringUtils.isNotBlank((String)res)) {
            jso.element("status", (Object)res);
        }
        return new StringBlob(jso.toString(), MIME_JSON);
    }
}

