/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.jtajca.internal;

import com.codahale.metrics.JmxAttributeGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.ObjectInstance;
import javax.resource.spi.ManagedConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.log4j.MDC;
import org.nuxeo.ecm.core.management.jtajca.ConnectionPoolMonitor;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultMonitorComponent;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.SoftRefCachingMapper;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionImpl;
import org.nuxeo.runtime.metrics.MetricsService;
import org.tranql.connector.AbstractManagedConnection;

public class DefaultConnectionPoolMonitor
implements ConnectionPoolMonitor {
    private static final Log log = LogFactory.getLog(DefaultConnectionPoolMonitor.class);
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final String name;
    protected AbstractConnectionManager cm;
    private static final Field SESSION_FIELD = DefaultConnectionPoolMonitor.field(ManagedConnectionImpl.class, "session");
    private static final Field WRAPPED_FIELD = DefaultConnectionPoolMonitor.field(SoftRefCachingMapper.class, "mapper");
    protected ObjectInstance self;

    protected DefaultConnectionPoolMonitor(String mame, AbstractConnectionManager cm) {
        this.name = mame;
        this.cm = this.enhanceConnectionManager(cm);
    }

    protected static Field field(Class<?> clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get access to " + clazz + "#" + name + " field");
        }
    }

    protected static <T> T fetch(Field field, Object object) {
        try {
            return (T)field.get(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get access to field content", e);
        }
    }

    protected static void save(Field field, Object object, Object value) {
        try {
            field.set(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot set field content", e);
        }
    }

    protected AbstractConnectionManager enhanceConnectionManager(AbstractConnectionManager cm) {
        if (!log.isTraceEnabled()) {
            return cm;
        }
        Field field = DefaultConnectionPoolMonitor.field(AbstractConnectionManager.class, "interceptors");
        AbstractConnectionManager.Interceptors interceptors = (AbstractConnectionManager.Interceptors)DefaultConnectionPoolMonitor.fetch(field, cm);
        interceptors = this.enhanceInterceptors(interceptors);
        DefaultConnectionPoolMonitor.save(field, cm, interceptors);
        return cm;
    }

    protected AbstractConnectionManager.Interceptors enhanceInterceptors(AbstractConnectionManager.Interceptors interceptors) {
        Field field = DefaultConnectionPoolMonitor.field(interceptors.getClass(), "stack");
        ConnectionInterceptor stack = (ConnectionInterceptor)DefaultConnectionPoolMonitor.fetch(field, interceptors);
        DefaultConnectionPoolMonitor.save(field, interceptors, this.enhanceStack(stack));
        return interceptors;
    }

    protected ConnectionInterceptor enhanceStack(ConnectionInterceptor stack) {
        try {
            Field field = DefaultConnectionPoolMonitor.field(stack.getClass(), "next");
            ConnectionInterceptor next = (ConnectionInterceptor)DefaultConnectionPoolMonitor.fetch(field, stack);
            DefaultConnectionPoolMonitor.save(field, stack, this.enhanceStack(next));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return (ConnectionInterceptor)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ConnectionInterceptor.class}, (InvocationHandler)new StackHandler(stack));
    }

    protected Mapper.Identification mapperId(ManagedConnection connection) {
        SessionImpl session = (SessionImpl)DefaultConnectionPoolMonitor.fetch(SESSION_FIELD, connection);
        Mapper mapper = session.getMapper();
        if (mapper instanceof SoftRefCachingMapper) {
            mapper = (Mapper)DefaultConnectionPoolMonitor.fetch(WRAPPED_FIELD, mapper);
        }
        try {
            return mapper.getIdentification();
        }
        catch (StorageException e) {
            log.error((Object)"Cannot fetch mapper identification", (Throwable)e);
            return null;
        }
    }

    @Override
    public void install() {
        this.self = DefaultMonitorComponent.bind(this, this.name);
        this.registry.register(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.name, "connections", "count"}), (Metric)new JmxAttributeGauge(this.self.getObjectName(), "ConnectionCount"));
        this.registry.register(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.name, "connections", "idle"}), (Metric)new JmxAttributeGauge(this.self.getObjectName(), "IdleConnectionCount"));
    }

    @Override
    public void uninstall() {
        DefaultMonitorComponent.unbind(this.self);
        this.registry.remove(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.name, "connections", "count"}));
        this.registry.remove(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.name, "connections", "idle"}));
        this.self = null;
    }

    public int getConnectionCount() {
        return this.cm.getConnectionCount();
    }

    public int getIdleConnectionCount() {
        return this.cm.getIdleConnectionCount();
    }

    public int getBlockingTimeoutMilliseconds() {
        return this.cm.getBlockingTimeoutMilliseconds();
    }

    public int getIdleTimeoutMinutes() {
        return this.cm.getIdleTimeoutMinutes();
    }

    public int getPartitionCount() {
        return this.cm.getPartitionCount();
    }

    public int getPartitionMaxSize() {
        return this.cm.getPartitionMaxSize();
    }

    public void setPartitionMaxSize(int maxSize) throws InterruptedException {
        this.cm.setPartitionMaxSize(maxSize);
    }

    public int getPartitionMinSize() {
        return this.cm.getPartitionMinSize();
    }

    public void setPartitionMinSize(int minSize) {
        this.cm.setPartitionMinSize(minSize);
    }

    public void setBlockingTimeoutMilliseconds(int timeoutMilliseconds) {
        this.cm.setBlockingTimeoutMilliseconds(timeoutMilliseconds);
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.cm.setIdleTimeoutMinutes(idleTimeoutMinutes);
    }

    public void handleNewConnectionManager(AbstractConnectionManager cm) {
        this.cm = this.enhanceConnectionManager(cm);
    }

    static interface IdProvider {
        public String key();

        public Object id(ManagedConnection var1);
    }

    protected class StackHandler
    implements InvocationHandler {
        protected final ConnectionInterceptor stack;
        protected IdProvider midProvider;

        public StackHandler(ConnectionInterceptor stack) {
            this.stack = stack;
        }

        protected void traceInvoke(Method m, Object[] args) {
            Throwable stackTrace = null;
            if (ConnectionInterceptor.class.isAssignableFrom(m.getDeclaringClass())) {
                stackTrace = new Throwable("debug stack trace");
            }
            log.trace((Object)("invoked " + this.stack.getClass().getSimpleName() + "." + m.getName()), stackTrace);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object object = method.invoke((Object)this.stack, args);
                return object;
            }
            finally {
                String name = method.getName();
                this.traceInvoke(method, args);
                if (args != null && args.length > 0) {
                    ConnectionInfo info = (ConnectionInfo)args[0];
                    ManagedConnection connection = info.getManagedConnectionInfo().getManagedConnection();
                    IdProvider midProvider = this.guessProvider(connection);
                    if (name.startsWith("get")) {
                        MDC.put((String)midProvider.key(), (Object)midProvider.id(connection));
                    } else if (name.startsWith("return")) {
                        MDC.remove((String)midProvider.key());
                    }
                }
            }
        }

        protected IdProvider guessProvider(ManagedConnection connection) {
            if (this.midProvider != null) {
                return this.midProvider;
            }
            if (connection instanceof ManagedConnectionImpl) {
                return new IdProvider(){

                    @Override
                    public String key() {
                        return "vcs";
                    }

                    @Override
                    public Object id(ManagedConnection connection) {
                        return DefaultConnectionPoolMonitor.this.mapperId(connection);
                    }
                };
            }
            if (connection instanceof AbstractManagedConnection) {
                return new IdProvider(){

                    @Override
                    public String key() {
                        return "db";
                    }

                    @Override
                    public Object id(ManagedConnection connection) {
                        return ((AbstractManagedConnection)connection).getPhysicalConnection();
                    }
                };
            }
            throw new IllegalArgumentException("unknown connection type of " + connection.getClass());
        }
    }
}

