/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.jsf.OperationHelper;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsPersistenceManager;

@Operation(id="Seam.ClearList", category="User Interface", requires="Seam", label="Clear a list which name is passed-in parameter", description="Clear the specified list content. Return void.")
public class ClearList {
    public static final String ID = "Seam.ClearList";
    @Context
    protected OperationContext ctx;
    @Param(name="The list name to reset", required=true)
    protected String listName;

    @OperationMethod
    public void run() {
        if (OperationHelper.isSeamContextAvailable()) {
            OperationHelper.getDocumentListManager().resetWorkingList(this.listName);
        } else {
            DocumentsListsPersistenceManager pm = new DocumentsListsPersistenceManager();
            pm.clearPersistentList(this.ctx.getPrincipal().getName(), this.listName);
        }
    }
}

