/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.api.ConverterCheckResult;

@Operation(id="Convert.ConvertBlobToPdf", category="Conversion", label="Convert To PDF and get nb page", description="Convert the input file to a PDF and return document updated with pdf and nb page")
public class ConvertBlobToPdf {
    private static final String TRANSFO_ERROR_NBPAGE = "Le calcul du nombre de pages a \u00e9chou\u00e9.";
    private static final String TRANSFO_ERROR_CLIENT_EXCEPTION = "Attention suite \u00e0 une erreur le fichier n'a pas \u00e9t\u00e9 transform\u00e9.Le fichier imprimable est nul.";
    private static final String TRANSFO_ERROR_PROPERTY_EXCEPTION = "Attention suite \u00e0 une erreur le fichier n'a pas \u00e9t\u00e9 transform\u00e9.Le fichier imprimable est nul.";
    private static final String TRANSFO_ERROR_CONVERSION_EXCEPTION = "Attention suite \u00e0 une erreur le fichier n'a pas \u00e9t\u00e9 transform\u00e9.Le fichier imprimable est nul.";
    private static final String TRANSFO_ERROR_TYPEMIMENONSUPPORTE = "Le fichier ne peut-\u00eatre transform\u00e9 en pdf. Le fichier \u00e0 imprimer sera le fichier original.";
    private static final String TRANSFO_ERROR_BLOBNULL = "Le fichier \u00e0 transformer est null.";
    private static final Log log = LogFactory.getLog(ConvertBlobToPdf.class);
    private static final String EXTENSION_PDF = ".pdf";
    private static final String APPLICATION_PDF = "application/pdf";
    public static final String ID = "Convert.ConvertBlobToPdf";
    public static final String VAR_NBPAGE = "nbPagePdf";
    public static final String VAR_BLOB = "blobPdf";
    public static final String VAR_MSG_RETOUR = "msgRetour";
    protected ConverterCheckResult pdfConverterAvailability;
    @Param(name="xpathBlob", required=true, order=0)
    protected String xpathblob;
    @Param(name="xpathNbPage", required=false, order=1)
    protected String xpathnbpage;
    @Context
    protected ConversionService service;
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws OperationException, IOException, ClientException {
        long t0 = System.currentTimeMillis();
        String msgRetour = "";
        log.debug((Object)("---> D\u00e9but de la conversion PDF du document: " + doc.getTitle()));
        this.putValueInDoc(doc, null, 0);
        try {
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh == null) {
                msgRetour = TRANSFO_ERROR_BLOBNULL;
            } else {
                String mtSrc = bh.getBlob().getMimeType();
                Blob blobResultat = null;
                Integer nbPages = null;
                if (APPLICATION_PDF.equals(mtSrc)) {
                    blobResultat = bh.getBlob();
                    nbPages = this.getNbPage(blobResultat);
                } else if (this.isMimeTypeExportableToPDF(mtSrc)) {
                    BlobHolder pdfBh = this.service.convertToMimeType(APPLICATION_PDF, bh, new HashMap());
                    blobResultat = pdfBh.getBlob();
                    log.debug((Object)("Temps de conversion PDF (" + doc.getTitle() + "): " + (System.currentTimeMillis() - t0) + "ms"));
                    String fname = bh.getBlob().getFilename();
                    if (fname != null) {
                        int idx = fname.lastIndexOf(46);
                        fname = idx != -1 ? fname.substring(0, idx) + EXTENSION_PDF : fname + EXTENSION_PDF;
                        blobResultat.setFilename(fname);
                    }
                    nbPages = this.getNbPage(blobResultat);
                } else {
                    blobResultat = bh.getBlob();
                    msgRetour = TRANSFO_ERROR_TYPEMIMENONSUPPORTE;
                }
                if (blobResultat != null && blobResultat.getMimeType() == null) {
                    blobResultat.setMimeType(APPLICATION_PDF);
                }
                this.putValueInDoc(doc, blobResultat, nbPages);
            }
            if (!msgRetour.isEmpty()) {
                OperationException oe = new OperationException(msgRetour);
                oe.setNoRollback();
                log.debug((Object)("Temps de conversion PDF (" + doc.getTitle() + "): " + (System.currentTimeMillis() - t0) + "ms"));
                throw oe;
            }
        }
        catch (ConversionException e) {
            log.error((Object)(" *** ConversionException " + e.getMessage()));
            msgRetour = "Attention suite \u00e0 une erreur le fichier n'a pas \u00e9t\u00e9 transform\u00e9.Le fichier imprimable est nul.";
            OperationException oe = new OperationException(msgRetour, (Throwable)e);
            oe.setNoRollback();
            throw oe;
        }
        catch (PropertyException e) {
            log.error((Object)(" *** PropertyException " + e.getMessage()));
            msgRetour = "Attention suite \u00e0 une erreur le fichier n'a pas \u00e9t\u00e9 transform\u00e9.Le fichier imprimable est nul.";
            OperationException oe = new OperationException(msgRetour, (Throwable)e);
            oe.setNoRollback();
            throw oe;
        }
        catch (ClientException e) {
            log.error((Object)(" *** ClientException " + e.getMessage()));
            msgRetour = "Attention suite \u00e0 une erreur le fichier n'a pas \u00e9t\u00e9 transform\u00e9.Le fichier imprimable est nul.";
            OperationException oe = new OperationException(msgRetour, (Throwable)e);
            oe.setNoRollback();
            throw oe;
        }
        catch (Exception e) {
            OperationException oe;
            if (!(e instanceof OperationException)) {
                log.error((Object)(" *** Exception : " + e.getMessage()));
                msgRetour = "Attention suite \u00e0 une erreur le fichier n'a pas \u00e9t\u00e9 transform\u00e9.Le fichier imprimable est nul.";
                oe = new OperationException(msgRetour, (Throwable)e);
                oe.setNoRollback();
            } else {
                oe = (OperationException)e;
            }
            throw oe;
        }
        log.debug((Object)("<--- Fin de la conversion PDF du document (" + doc.getTitle() + ")" + (System.currentTimeMillis() - t0) + "ms"));
        return doc;
    }

    private void putValueInDoc(DocumentModel doc, Blob blobResultat, Integer nbPages) throws PropertyException, ClientException {
        if (this.xpathnbpage != null) {
            doc.setPropertyValue(this.xpathnbpage, (Serializable)nbPages);
        } else {
            this.ctx.put(VAR_NBPAGE, (Object)nbPages);
        }
        if (this.xpathblob != null) {
            doc.setPropertyValue(this.xpathblob, (Serializable)blobResultat);
        } else {
            this.ctx.put(VAR_BLOB, (Object)blobResultat);
        }
    }

    private Integer getNbPage(Blob blobPdf) throws OperationException, IOException {
        Integer nbPages;
        long t0 = System.currentTimeMillis();
        InputStream is = null;
        PDDocument docPdfBox = null;
        try {
            is = blobPdf.getStream();
            docPdfBox = null;
            PDFParser parser = new PDFParser(is);
            parser.parse();
            docPdfBox = parser.getPDDocument();
            nbPages = docPdfBox.getNumberOfPages();
        }
        catch (IOException e) {
            OperationException oe = new OperationException(TRANSFO_ERROR_NBPAGE, e.getCause());
            throw oe;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (docPdfBox != null) {
                docPdfBox.close();
            }
        }
        log.debug((Object)(" Calcul nombre de page (" + nbPages + "): " + (System.currentTimeMillis() - t0) + "ms"));
        return nbPages;
    }

    protected boolean isMimeTypeExportableToPDF(String mimetype) throws ConversionException {
        long t0 = System.currentTimeMillis();
        boolean res = false;
        try {
            for (String pdfConverterName : this.service.getConverterNames(mimetype, APPLICATION_PDF)) {
                this.pdfConverterAvailability = this.service.isConverterAvailable(pdfConverterName, true);
                if (!this.pdfConverterAvailability.isAvailable()) continue;
                res = true;
                break;
            }
        }
        catch (Exception e) {
            ConversionException ce = new ConversionException("Error while testing PDF converter availability");
            log.error((Object)("Error while testing PDF converter availability " + e.getMessage()));
            throw ce;
        }
        log.debug((Object)(" test type mime : " + (System.currentTimeMillis() - t0) + "ms"));
        return res;
    }
}

