/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import java.util.Map;
import net.sf.json.JSONArray;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;

@Operation(id="Document.GetChildrenTypes", category="Document", label="Get children allowed types ", description="Returns children types.")
public class GetChildrenTypes {
    static final String ID = "Document.GetChildrenTypes";
    @Context
    protected TypeManager typeManager;

    @OperationMethod
    public Blob run(DocumentModel doc) throws Exception {
        JSONArray array = null;
        Type cType = this.typeManager.getType(doc.getType());
        Map allowedSubTypes = cType.getAllowedSubTypes();
        if (allowedSubTypes != null) {
            array = new JSONArray();
            for (String typeName : allowedSubTypes.keySet()) {
                array.add((Object)typeName);
            }
        }
        return new StringBlob(array.toString(), "application/json");
    }
}

