/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeFilter;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;

@Operation(id="Document.GetFilteredDocumentACEs", category="Document", label="Get document ACEs", description="Retour la liste des ACEs du document")
public class GetFilteredDocumentACEs {
    public static final String ID = "Document.GetFilteredDocumentACEs";
    private static final String ACE_FORMAT = "%s:%s:%s";
    @Param(name="aclName", required=true, values={"local"})
    protected String aclName;
    @Param(name="permissionExcluded", required=false)
    protected String permOff;
    @Param(name="variable name", required=true)
    protected String key;
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        String aces = "";
        ToutaticeFilter<ACE> filter = new ToutaticeFilter<ACE>(){
            private static final long serialVersionUID = 1L;

            public boolean accept(ACE t) {
                String[] tabPerm;
                boolean b = true;
                if (StringUtils.isNotBlank((String)GetFilteredDocumentACEs.this.permOff) && (tabPerm = GetFilteredDocumentACEs.this.permOff.split(",")).length > 0) {
                    for (int i = 0; i < tabPerm.length; ++i) {
                        b = b && !tabPerm[i].equals(t.getPermission());
                    }
                }
                return t.isGranted() && b;
            }
        };
        ACL acl = ToutaticeDocumentHelper.getDocumentACL((CoreSession)this.session, (DocumentModel)doc, (String)this.aclName, (ToutaticeFilter)filter);
        ArrayList<String> entries = new ArrayList<String>();
        for (ACE ace : acl) {
            entries.add(String.format(ACE_FORMAT, ace.getUsername(), ace.getPermission(), true));
        }
        aces = StringUtils.join(entries, (char)',');
        this.ctx.put(this.key, (Object)aces);
        return doc;
    }
}

