/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelListCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.uidgen.service.ServiceHelper;
import org.nuxeo.ecm.platform.uidgen.service.UIDGeneratorService;

@Operation(id="Document.SetSequenceId", category="Document", label="Generate a unique ID given a key passed-in parameter.", description="Based on a sequence object from database, will generate a unique identifier. Unicity is garanteed for the provided key element only.")
public class SetSequenceId {
    public static final String ID = "Document.SetSequenceId";
    private static final Log log = LogFactory.getLog(SetSequenceId.class);
    private UIDGeneratorService UIDGeneratorService;
    @Context
    protected CoreSession session;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        UIDGeneratorRunner runner = new UIDGeneratorRunner(this.session, doc);
        runner.silentRun(true);
        return doc;
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) throws Exception {
        return this.run(this.session.getDocument(docRef));
    }

    @OperationMethod(collector=DocumentModelListCollector.class)
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        for (DocumentModel doc : docs) {
            this.run(doc);
        }
        return docs;
    }

    private UIDGeneratorService getUIDGeneratorService() {
        if (null == this.UIDGeneratorService) {
            this.UIDGeneratorService = ServiceHelper.getUIDGeneratorService();
            if (this.UIDGeneratorService == null) {
                log.error((Object)"Failed to get the service to generate a UID");
            }
        }
        return this.UIDGeneratorService;
    }

    private class UIDGeneratorRunner
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel document;

        public UIDGeneratorRunner(CoreSession session, DocumentModel document) {
            super(session);
            this.document = document;
        }

        public void run() throws ClientException {
            if (null != this.document) {
                try {
                    UIDGeneratorService service = SetSequenceId.this.getUIDGeneratorService();
                    service.setUID(this.document);
                    this.session.saveDocument(this.document);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to set an UID to the document '" + this.document.getTitle() + "', error: " + e.getMessage()));
                }
            }
        }
    }
}

