/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation.freemarker;

import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.rendering.FreemarkerRender;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.features.PlatformFunctions;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.AbstractProperty;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.storage.binary.Binary;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBlob;
import org.nuxeo.ecm.platform.rendering.fm.adapters.BlobTemplate;
import org.nuxeo.ecm.platform.rendering.fm.adapters.ComplexPropertyTemplate;
import org.nuxeo.ecm.platform.rendering.fm.adapters.DocumentObjectWrapper;
import org.nuxeo.ecm.platform.rendering.fm.adapters.ListPropertyTemplate;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.FileSource;

public class AcarennesExportFunctions
extends PlatformFunctions {
    private static final Log log = LogFactory.getLog(AcarennesExportFunctions.class);
    private static final String BI = "BREAK-INHERITANCE";
    private static DocumentObjectWrapper wrapper = new DocumentObjectWrapper(null);

    public DocumentModelList getChildren(CoreSession session, DocumentModel root) throws ClientException {
        return session.getChildren(root.getRef(), null, new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean accept(DocumentModel document) {
                boolean status = false;
                try {
                    status = !document.isProxy() && !"deleted".equals(document.getCurrentLifeCycleState());
                }
                catch (ClientException e) {
                    log.error((Object)("Failed to list the document children, error: " + e.getMessage()));
                }
                return status;
            }
        }, null);
    }

    public String getChildXML(CoreSession session, DocumentModel child, String template) {
        String result = "";
        OperationContext childCtx = new OperationContext(session);
        childCtx.setInput((Object)child);
        Map map = Scripting.initBindings((OperationContext)childCtx);
        try {
            StringWriter writer = new StringWriter();
            FreemarkerRender ftl = new FreemarkerRender();
            ftl.render(template, (Object)map, (Writer)writer);
            ((Writer)writer).flush();
            result = ((Object)writer).toString();
        }
        catch (Exception e) {
            log.error((Object)("Failed to render the template '" + template + "', error: " + e.getMessage()));
        }
        return result;
    }

    public String getPropertiesXML(CoreSession session, DocumentModel document, List<Map<String, TemplateModel>> properties, String template) {
        String result = "";
        OperationContext ctx = new OperationContext(session);
        ctx.setInput((Object)document);
        Map map = Scripting.initBindings((OperationContext)ctx);
        map.put("Properties", properties);
        try {
            StringWriter writer = new StringWriter();
            FreemarkerRender ftl = new FreemarkerRender();
            ftl.render(template, (Object)map, (Writer)writer);
            ((Writer)writer).flush();
            result = ((Object)writer).toString();
        }
        catch (Exception e) {
            log.error((Object)("Failed to render the template '" + template + "', error: " + e.getMessage()));
        }
        return result;
    }

    public boolean isBrokenACP(CoreSession session, DocumentModel document) {
        boolean status = false;
        Map<String, List<Map<String, String>>> acp = this.getACP(session, document);
        status = acp.containsKey(BI);
        return status;
    }

    public Map<String, List<Map<String, String>>> getACP(CoreSession session, DocumentModel document) {
        HashMap<String, List<Map<String, String>>> acpMap = new HashMap<String, List<Map<String, String>>>();
        try {
            ACL[] acls;
            ACP acp = session.getACP(document.getRef());
            for (ACL acl : acls = acp.getACLs()) {
                ACE[] aces = acl.getACEs();
                ArrayList aclList = new ArrayList();
                acpMap.put(acl.getName(), aclList);
                for (ACE ace : aces) {
                    HashMap<String, String> aceMap = new HashMap<String, String>();
                    aceMap.put("principal", ace.getUsername());
                    aceMap.put("permission", ace.getPermission());
                    aceMap.put("granted", Boolean.toString(ace.isGranted()));
                    if (!"inherited".equals(acl) && this.isInehiranceBroken(ace)) {
                        acpMap.put(BI, null);
                        continue;
                    }
                    aclList.add(aceMap);
                }
            }
        }
        catch (ClientException e) {
            log.error((Object)("Failed to get the document ACP, error: " + e.getMessage()));
        }
        return acpMap;
    }

    public String getLifeCycle(DocumentModel document) {
        String state = "";
        try {
            state = document.getCurrentLifeCycleState();
        }
        catch (ClientException e) {
            log.error((Object)("Failed to get the life cycle state of the document, error: " + e.getMessage()));
        }
        return state;
    }

    public List<Map<String, TemplateModel>> getProperties(CoreSession session, DocumentModel document, String schemaName) throws ClientException, TemplateModelException {
        ArrayList<Map<String, TemplateModel>> properties = new ArrayList<Map<String, TemplateModel>>();
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        Schema schema = schemaManager.getSchema(schemaName);
        Collection fields = schema.getFields();
        for (Field field : fields) {
            Property p = document.getProperty(field.getName().toString());
            if (null == p || null == p.getValue()) continue;
            HashMap<String, TemplateModel> property = new HashMap<String, TemplateModel>();
            property.put(this.getFieldName(schema, field), wrapper.wrap((Object)p));
            properties.add(property);
        }
        return properties;
    }

    public List<Map<String, TemplateModel>> getProperties(CoreSession session, DocumentModel document, AbstractProperty sequence) throws ClientException, TemplateModelException {
        ArrayList<Map<String, TemplateModel>> properties = new ArrayList<Map<String, TemplateModel>>();
        Collection prs = sequence.getChildren();
        for (Property pr : prs) {
            Field field = pr.getField();
            HashMap<String, TemplateModel> property = new HashMap<String, TemplateModel>();
            property.put(this.getFieldName(null, field), wrapper.wrap((Object)pr));
            properties.add(property);
        }
        return properties;
    }

    public boolean isComplexPropertyType(Object property) throws TemplateModelException {
        TemplateModel wObj = wrapper.wrap(property);
        return wObj instanceof ListPropertyTemplate || wObj instanceof ComplexPropertyTemplate;
    }

    public boolean isBlobType(Object obj) throws TemplateModelException {
        return obj instanceof SQLBlob;
    }

    public TemplateModel getBlobTemplate(SQLBlob blob) {
        return new AcarenBlobTemplate(wrapper, (Blob)blob);
    }

    public String escapeXML(String xml) {
        return StringEscapeUtils.escapeXml((String)xml);
    }

    private boolean isInehiranceBroken(ACE ace) {
        return ace.getPermission().equals("Everything") && ace.getUsername().equals("Everyone") && ace.isDenied();
    }

    private String getFieldName(Schema schema, Field field) {
        String xpath = field.getName().toString();
        QName name = field.getName();
        if (!xpath.matches(".+:.+") && null != schema) {
            xpath = schema.getName() + ":" + name.getLocalName();
        }
        return xpath;
    }

    private class AcarenBlobTemplate
    extends BlobTemplate {
        private static final String BLOB_PATH = "path";
        private static final String BLOB_DATA = "data";

        public AcarenBlobTemplate(DocumentObjectWrapper wrapper, Blob blob) {
            super(wrapper, blob);
        }

        public TemplateCollectionModel keys() throws TemplateModelException {
            ArrayList<String> collection = new ArrayList<String>();
            for (String key : keys) {
                if (BLOB_DATA.equals(key)) continue;
                collection.add(key);
            }
            if (this.blob instanceof SQLBlob || this.blob instanceof FileBlob) {
                collection.add(BLOB_PATH);
            }
            SimpleCollection sc = new SimpleCollection(collection, (ObjectWrapper)this.wrapper);
            return sc;
        }

        public TemplateModel get(String name) throws TemplateModelException {
            TemplateModel value = NOTHING;
            if (null != this.blob) {
                if (BLOB_PATH.equals(name)) {
                    try {
                        File file = null;
                        if (this.blob instanceof SQLBlob) {
                            SQLBlob sqlBlob = (SQLBlob)this.blob;
                            Binary binary = sqlBlob.getBinary();
                            FileSource source = (FileSource)binary.getStreamSource();
                            file = source.getFile();
                        } else if (this.blob instanceof FileBlob) {
                            FileBlob fileBlob = (FileBlob)this.blob;
                            file = fileBlob.getFile();
                        }
                        if (null != file) {
                            value = new SimpleScalar(file.getAbsolutePath());
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    value = super.get(name);
                }
            }
            return value;
        }
    }
}

