/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.forms;

import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterInstance;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FormFilterExecutor {
    private Map<String, List<FormFilterInstance>> filtersByParentPathMap;
    private String currentPath;
    private String currentFilterInstanceId;

    public FormFilterExecutor(Map<String, List<FormFilterInstance>> filtersByParentPathMap, String currentPath, String currentFilterInstanceId) {
        this.filtersByParentPathMap = filtersByParentPathMap;
        this.currentPath = currentPath;
        this.currentFilterInstanceId = currentFilterInstanceId;
    }

    public void executeChildren(FormFilterContext filterContext) throws FormFilterException {
        List<FormFilterInstance> filters = this.filtersByParentPathMap.get(this.currentPath);
        if (filters != null) {
            Collections.sort(filters);
            for (FormFilterInstance formFilterI : filters) {
                formFilterI.getFormFilter().execute(filterContext, new FormFilterExecutor(this.filtersByParentPathMap, formFilterI.getPath(), formFilterI.getId()));
            }
        }
    }

    public String getCurrentFilterInstanceId() {
        return this.currentFilterInstanceId;
    }
}

