/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.batch;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoServiceFactory;
import java.util.Map;
import java.util.UUID;
import javax.portlet.PortletContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.batch.AbstractBatch;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public abstract class NuxeoBatch
extends AbstractBatch {
    private NuxeoController nuxeoController;
    private ICMSServiceLocator locator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");

    protected NuxeoController getNuxeoController() {
        if (this.nuxeoController == null) {
            this.nuxeoController = new NuxeoController(this.getPortletContext());
            this.nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
            this.nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
            this.nuxeoController.setForcePublicationInfosScope("superuser_context");
        }
        return this.nuxeoController;
    }

    protected Map<String, String> startProcedure(String modelId, Map<String, String> variables) throws PortalException, FormFilterException {
        IFormsService formsService = NuxeoServiceFactory.getFormsService();
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), null, null);
        return formsService.start(portalControllerContext, modelId, variables);
    }

    protected Map<String, String> proceed(String uuid, String action, Map<String, String> variables) throws PortalException, FormFilterException, CMSException {
        IFormsService formsService = NuxeoServiceFactory.getFormsService();
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), null, null);
        Document task = this.getTask(uuid);
        return formsService.proceed(portalControllerContext, task, action, variables);
    }

    protected Document getTask(String uuid) throws CMSException {
        ICMSService cmsService = this.locator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortletCtx(this.getPortletContext());
        cmsContext.setScope("superuser_no_cache");
        return (Document)cmsService.getTask(cmsContext, null, null, UUID.fromString(uuid));
    }

    protected abstract PortletContext getPortletContext();
}

