/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.automation.client.LoginInfo;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshaller;

public class LoginMarshaller
implements JsonMarshaller<LoginInfo> {
    @Override
    public String getType() {
        return "login";
    }

    @Override
    public Class<LoginInfo> getJavaType() {
        return LoginInfo.class;
    }

    public String getReference(LoginInfo info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LoginInfo read(JsonParser jp) throws Exception {
        boolean isAdmin = false;
        String username = null;
        Set<String> groups = null;
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            if ("username".equals(key)) {
                username = jp.getText();
            } else if ("isAdministrator".equals(key)) {
                isAdmin = Boolean.parseBoolean(jp.getText());
            } else if ("groups".equals(key)) {
                jp.nextToken();
                groups = this.readGroups(jp);
            }
            tok = jp.nextToken();
        }
        return new LoginInfo(username, groups, isAdmin);
    }

    protected Set<String> readGroups(JsonParser jp) throws Exception {
        HashSet<String> groups = new HashSet<String>();
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_ARRAY) {
            groups.add(jp.getText());
            tok = jp.nextToken();
        }
        return groups;
    }

    @Override
    public void write(JsonGenerator jg, LoginInfo value) throws Exception {
        jg.writeStringField("username", value.getUsername());
        jg.writeBooleanField("isAdministrator", value.isAdministrator());
        jg.writeArrayFieldStart("groups");
        String[] groups = value.getGroups();
        if (groups != null) {
            for (String g : groups) {
                jg.writeString(g);
            }
        }
        jg.writeEndArray();
    }
}

