/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.model;

import java.util.Date;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.EcmDocument;

public class Document
extends DocRef
implements EcmDocument {
    private static final long serialVersionUID = 1L;
    protected final String repository;
    protected final String path;
    protected final String type;
    protected final String state;
    protected final String lockOwner;
    protected final String lockCreated;
    protected final String versionLabel;
    protected final PropertyMap properties;
    protected final PropertyMap contextParameters;
    protected final String changeToken;
    protected final PropertyList facets;

    @Deprecated
    public Document(String id, String type, PropertyList facets, String changeToken, String path, String state, String lockOwner, String lockCreated, String repository, PropertyMap properties, PropertyMap contextParameters) {
        this(id, type, facets, changeToken, path, state, lockOwner, lockCreated, repository, null, properties, contextParameters);
    }

    public Document(String id, String type, PropertyList facets, String changeToken, String path, String state, String lockOwner, String lockCreated, String repository, String versionLabel, PropertyMap properties, PropertyMap contextParameters) {
        super(id);
        this.changeToken = changeToken;
        this.facets = facets;
        this.path = path;
        this.type = type;
        this.state = state;
        this.lockOwner = lockOwner;
        this.lockCreated = lockCreated;
        this.repository = repository;
        this.versionLabel = versionLabel;
        this.properties = properties == null ? new PropertyMap() : properties;
        this.contextParameters = contextParameters == null ? new PropertyMap() : contextParameters;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getId() {
        return this.ref;
    }

    @Override
    public String getInputType() {
        return "document";
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public String getLock() {
        if (this.lockOwner != null && this.lockCreated != null) {
            return this.lockOwner + ":" + this.lockCreated;
        }
        return null;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public String getLockCreated() {
        return this.lockCreated;
    }

    public boolean isLocked() {
        return this.lockOwner != null;
    }

    public String getState() {
        return this.state;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public Date getLastModified() {
        return this.properties.getDate("dc:modified");
    }

    public String getTitle() {
        return this.properties.getString("dc:title");
    }

    public PropertyMap getProperties() {
        return this.properties;
    }

    public String getString(String key) {
        return this.properties.getString(key);
    }

    public Date getDate(String key) {
        return this.properties.getDate(key);
    }

    public Long getLong(String key) {
        return this.properties.getLong(key);
    }

    public Double getDouble(String key) {
        return this.properties.getDouble(key);
    }

    public String getString(String key, String defValue) {
        return this.properties.getString(key, defValue);
    }

    public Date getDate(String key, Date defValue) {
        return this.properties.getDate(key, defValue);
    }

    public Long getLong(String key, Long defValue) {
        return this.properties.getLong(key, defValue);
    }

    public Double getDouble(String key, Double defValue) {
        return this.properties.getDouble(key, defValue);
    }

    public void set(String key, String defValue) {
        this.properties.set(key, defValue);
    }

    public void set(String key, Date defValue) {
        this.properties.set(key, defValue);
    }

    public void set(String key, Long defValue) {
        this.properties.set(key, defValue);
    }

    public void set(String key, Double defValue) {
        this.properties.set(key, defValue);
    }

    public String getChangeToken() {
        return this.changeToken;
    }

    public PropertyList getFacets() {
        return this.facets;
    }

    public PropertyMap getContextParameters() {
        return this.contextParameters;
    }
}

