/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.model.PropertyList;

public class DocumentPermissions {
    private Map<String, List<String>> aces;

    public DocumentPermissions() {
        this.aces = new LinkedHashMap<String, List<String>>();
    }

    public DocumentPermissions(Map<String, List<String>> aces) {
        this.aces = aces;
    }

    public DocumentPermissions(int size) {
        this.aces = new LinkedHashMap<String, List<String>>(size);
    }

    public void setPermission(String userName, String permission) {
        if (this.aces.containsKey(userName)) {
            List<String> permissions = this.aces.get(userName);
            if (permissions != null) {
                permissions.add(permission);
            }
        } else {
            ArrayList<String> permissions = new ArrayList<String>();
            permissions.add(permission);
            this.aces.put(userName, permissions);
        }
    }

    public void setPermissions(String userName, List<String> permissions) {
        this.aces.put(userName, permissions);
    }

    public List<String> getPermissions(String userName) {
        return this.aces.get(userName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, List<String>> ace : this.aces.entrySet()) {
            builder.append(ace.getKey()).append("=");
            List<String> permissions = ace.getValue();
            if (permissions != null) {
                PropertyList propL = new PropertyList();
                propL.getList().addAll(permissions);
                builder.append(DocumentPermissions.toString(propL));
            }
            builder.append("\n ");
        }
        return builder.toString();
    }

    public static String toString(PropertyList list) {
        StringBuilder builder = new StringBuilder("[");
        Iterator<Object> iter = list.list().iterator();
        while (iter.hasNext()) {
            builder.append((String)iter.next());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }
}

