/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.model;

import java.util.Iterator;
import java.util.Map;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

final class NuxeoJsonMapper {
    private NuxeoJsonMapper() {
        throw new AssertionError((Object)"Classe utilitaire, ne pas instancier");
    }

    public static String toString(PropertyList list) {
        StringBuilder builder = new StringBuilder("[");
        Iterator<Object> iter = list.list().iterator();
        while (iter.hasNext()) {
            builder.append(NuxeoJsonMapper.objectToString(iter.next()));
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    public static String toString(PropertyMap map) {
        StringBuilder builder = new StringBuilder("{");
        Iterator<Map.Entry<String, Object>> iter = map.map().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            builder.append(entry.getKey()).append(":").append(NuxeoJsonMapper.objectToString(entry.getValue()));
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        builder.append("}");
        return builder.toString();
    }

    private static String objectToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return '\"' + NuxeoJsonMapper.escape((String)obj) + '\"';
        }
        if (obj instanceof PropertyMap) {
            return NuxeoJsonMapper.toString((PropertyMap)obj);
        }
        if (obj instanceof PropertyList) {
            return NuxeoJsonMapper.toString((PropertyList)obj);
        }
        return '\"' + NuxeoJsonMapper.escape(obj.toString()) + '\"';
    }

    private static String escape(String str) {
        return str.replaceAll("\n", "\\n").replaceAll("\"", "\\\"");
    }
}

