/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.model;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.automation.client.model.DateUtils;
import org.nuxeo.ecm.automation.client.model.NuxeoJsonMapper;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public final class NuxeoPropertyMap
extends PropertyMap
implements Map<String, Object> {
    private static final long serialVersionUID = 1L;

    public NuxeoPropertyMap() {
    }

    public NuxeoPropertyMap(PropertyMap props) {
        super(props);
    }

    public NuxeoPropertyMap(Map<String, Object> map) {
        super(map);
    }

    public NuxeoPropertyMap(int size) {
        super(size);
    }

    @Override
    public void set(String key, String value) {
        this.map.put(key, this.toInternalFormatValue(value));
    }

    private Object toInternalFormatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof PropertyMap || value instanceof PropertyList) {
            return value;
        }
        if (value instanceof Date) {
            return DateUtils.formatDate((Date)value);
        }
        return value.toString();
    }

    @Override
    public void set(String key, Boolean value) {
        this.map.put(key, this.toInternalFormatValue(value));
    }

    @Override
    public void set(String key, Long value) {
        this.map.put(key, this.toInternalFormatValue(value));
    }

    @Override
    public void set(String key, Double value) {
        this.map.put(key, this.toInternalFormatValue(value));
    }

    @Override
    public void set(String key, Date value) {
        this.map.put(key, this.toInternalFormatValue(value));
    }

    @Override
    public void set(String key, PropertyList value) {
        this.map.put(key, this.toInternalFormatValue(value));
    }

    @Override
    public void set(String key, PropertyMap value) {
        this.map.put(key, this.toInternalFormatValue(value));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(this.toInternalFormatValue(value));
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, this.toInternalFormatValue(value));
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> obj : m.entrySet()) {
            this.put(obj.getKey(), obj.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        NuxeoPropertyMap other = (NuxeoPropertyMap)obj;
        return this.map.equals(other.map);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.map.entrySet()) {
            builder.append((String)entry.getKey()).append("=");
            Object value = entry.getValue();
            if (value != null) {
                if (value instanceof String) {
                    builder.append(this.escapeCrLf((String)value));
                } else if (value instanceof PropertyMap) {
                    builder.append(NuxeoJsonMapper.toString((PropertyMap)value));
                } else if (value instanceof PropertyList) {
                    builder.append(NuxeoJsonMapper.toString((PropertyList)value));
                } else {
                    builder.append(this.escapeCrLf(value.toString()));
                }
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private String escapeCrLf(String str) {
        return str.replaceAll("\n", "\\n");
    }
}

