/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OperationDocumentation
implements Comparable<OperationDocumentation>,
Serializable {
    private static final long serialVersionUID = 1L;
    public String id;
    public String[] signature;
    public String category;
    public String label;
    public String requires;
    public String since;
    public String description;
    public List<Param> params;
    public String url;

    public OperationDocumentation() {
        this(null);
    }

    public OperationDocumentation(String id) {
        this.id = id;
        this.url = id;
        this.params = new ArrayList<Param>();
    }

    @Override
    public int compareTo(OperationDocumentation o) {
        String s1 = this.label == null ? this.id : this.label;
        String s2 = o.label == null ? o.id : o.label;
        return s1.compareTo(s2);
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getSignature() {
        return this.signature;
    }

    public String getCategory() {
        return this.category;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLabel() {
        return this.label;
    }

    public String getRequires() {
        return this.requires;
    }

    public List<Param> getParams() {
        return this.params;
    }

    public String toString() {
        return this.category + " > " + this.label + " [" + this.id + ": " + Arrays.asList(this.signature) + "] (" + this.params + ")\n" + this.description;
    }

    public static class Param
    implements Serializable,
    Comparable<Param> {
        private static final long serialVersionUID = 1L;
        public String name;
        public String type;
        public String widget;
        public String[] values;
        public boolean isRequired;

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getWidget() {
            return this.widget;
        }

        public String[] getValues() {
            return this.values;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public String toString() {
            return this.name + " [" + this.type + "] " + (this.isRequired ? "required" : "optional");
        }

        @Override
        public int compareTo(Param o) {
            if (this.isRequired && !o.isRequired) {
                return -1;
            }
            if (o.isRequired && !this.isRequired) {
                return 1;
            }
            return this.name.compareTo(o.name);
        }
    }
}

