/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.AdapterFactory;
import org.nuxeo.ecm.automation.client.AsyncCallback;
import org.nuxeo.ecm.automation.client.AutomationClient;
import org.nuxeo.ecm.automation.client.LoginCallback;
import org.nuxeo.ecm.automation.client.LoginInfo;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.TokenCallback;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.ConnectorHandler;
import org.nuxeo.ecm.automation.client.jaxrs.spi.DefaultSession;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;
import org.nuxeo.ecm.automation.client.jaxrs.spi.RequestInterceptor;
import org.nuxeo.ecm.automation.client.jaxrs.spi.auth.BasicAuthInterceptor;
import org.nuxeo.ecm.automation.client.jaxrs.spi.auth.TokenAuthInterceptor;
import org.nuxeo.ecm.automation.client.model.OperationRegistry;

public abstract class AbstractAutomationClient
implements AutomationClient {
    protected String url;
    protected volatile OperationRegistry registry;
    protected Map<Class<?>, List<AdapterFactory<?>>> adapters = new HashMap();
    protected RequestInterceptor requestInterceptor;

    protected AbstractAutomationClient(String url) {
        this.url = url.endsWith("/") ? url : url + "/";
    }

    public void setRequestInterceptor(RequestInterceptor interceptor) {
        this.requestInterceptor = interceptor;
    }

    public RequestInterceptor getRequestInterceptor() {
        return this.requestInterceptor;
    }

    @Override
    public String getBaseUrl() {
        return this.url;
    }

    public void setBasicAuth(String username, String password) {
        this.setRequestInterceptor(new BasicAuthInterceptor(username, password));
    }

    protected OperationRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void registerAdapter(AdapterFactory<?> factory) {
        Class<?> adapter = factory.getAdapterType();
        List<AdapterFactory<?>> factories = this.adapters.get(adapter);
        if (factories == null) {
            factories = new ArrayList();
            this.adapters.put(adapter, factories);
        }
        factories.add(factory);
    }

    @Override
    public <T> T getAdapter(Object objToAdapt, Class<T> adapterType) {
        Class<?> cls = objToAdapt.getClass();
        List<AdapterFactory<?>> factories = this.adapters.get(adapterType);
        if (factories != null) {
            for (AdapterFactory<?> f : factories) {
                if (!f.getAcceptType().isAssignableFrom(cls)) continue;
                return (T)f.getAdapter(objToAdapt);
            }
        }
        return null;
    }

    protected OperationRegistry connect(Connector connector) {
        Request req = new Request(0, this.url);
        req.put("Accept", "application/json+nxautomation");
        return (OperationRegistry)connector.execute(req);
    }

    @Override
    public synchronized void shutdown() {
        this.url = null;
        this.registry = null;
        this.adapters = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession() {
        Connector connector = this.newConnector();
        if (this.requestInterceptor != null) {
            connector = new ConnectorHandler(connector, this.requestInterceptor);
        }
        if (this.registry == null) {
            AbstractAutomationClient abstractAutomationClient = this;
            synchronized (abstractAutomationClient) {
                if (this.registry == null) {
                    this.registry = this.connect(connector);
                }
            }
        }
        return this.login(connector);
    }

    @Override
    public Session getSession(String username, String password) {
        return this.getSession(new BasicAuthInterceptor(username, password));
    }

    @Override
    public Session getSession(String token) {
        return this.getSession(new TokenAuthInterceptor(token));
    }

    protected Session getSession(RequestInterceptor interceptor) {
        this.setRequestInterceptor(interceptor);
        return this.getSession();
    }

    @Override
    public Session getSession(TokenCallback cb) {
        String token = cb.getLocalToken();
        if (token == null) {
            token = cb.getRemoteToken(cb.getTokenParams());
            cb.saveToken(token);
        }
        return this.getSession(token);
    }

    @Override
    public void getSession(String username, String password, AsyncCallback<Session> cb) {
        this.setBasicAuth(username, password);
        this.getSession(cb);
    }

    @Override
    public Session getSession(LoginCallback loginCb) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getSession(LoginCallback loginCb, AsyncCallback<Session> cb) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getSession(final AsyncCallback<Session> cb) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Session session = AbstractAutomationClient.this.getSession();
                    cb.onSuccess(session);
                }
                catch (Throwable t) {
                    cb.onError(t);
                }
            }
        });
    }

    protected Session login(Connector connector) {
        OperationRegistry registry = this.getRegistry();
        String path = registry.getPath("login");
        Request request = new Request(1, this.url + path);
        request.put("Accept", "application/json+nxentity");
        LoginInfo login = (LoginInfo)connector.execute(request);
        return this.createSession(connector, login);
    }

    protected Session createSession(Connector connector, LoginInfo login) {
        return new DefaultSession(this, connector, login == null ? LoginInfo.ANONYNMOUS : login);
    }

    public void asyncExec(Runnable runnable) {
        throw new UnsupportedOperationException("Async execution not supported");
    }

    protected abstract Connector newConnector();
}

