/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller.portlet;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.portal.core.CoreConstants;
import org.jboss.portal.core.controller.coordination.CoordinationManager;
import org.jboss.portal.core.controller.portlet.ControllerPortletControllerContext;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.navstate.PageNavigationalState;
import org.jboss.portal.core.model.portal.navstate.WindowNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateContext;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;
import org.jboss.portal.portlet.controller.state.PortletWindowNavigationalState;
import org.jboss.portal.portlet.info.NavigationInfo;
import org.jboss.portal.portlet.info.ParameterInfo;
import org.jboss.portal.portlet.info.PortletInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerPageNavigationalState
implements PortletPageNavigationalState {
    private static final String[] REMOVAL = new String[0];
    private final NavigationalStateContext navigationalStateContext;
    private final ControllerPortletControllerContext controllerContext;
    private final boolean mutable;
    private Map<String, WindowNavigationalState> updates;
    private Map<QName, String[]> pageUpdates;
    private Map<String, HashMap<QName, String[]>> windowPublicNavigationalStateUpdate;
    private final boolean implicitMode;

    public ControllerPageNavigationalState(NavigationalStateContext navigationalStateContext, ControllerPortletControllerContext controllerContext, boolean mutable) {
        this.navigationalStateContext = navigationalStateContext;
        this.controllerContext = controllerContext;
        this.mutable = mutable;
        this.updates = null;
        this.pageUpdates = null;
        this.windowPublicNavigationalStateUpdate = null;
        this.implicitMode = this.getCoordinationManager().resolveParameterBindingImplicitModeEnabled(controllerContext.getPage());
    }

    public ControllerPageNavigationalState(ControllerPageNavigationalState that, boolean mutable) {
        this.navigationalStateContext = that.navigationalStateContext;
        this.controllerContext = that.controllerContext;
        this.mutable = mutable;
        this.updates = that.updates != null ? new HashMap<String, WindowNavigationalState>(that.updates) : null;
        this.pageUpdates = that.pageUpdates != null ? new HashMap<QName, String[]>(that.pageUpdates) : null;
        this.windowPublicNavigationalStateUpdate = that.windowPublicNavigationalStateUpdate != null ? new Hashtable<String, HashMap<QName, String[]>>(that.windowPublicNavigationalStateUpdate) : null;
        this.implicitMode = this.getCoordinationManager().resolveParameterBindingImplicitModeEnabled(this.controllerContext.getPage());
    }

    /*
     * WARNING - void declaration
     */
    public void flushUpdates() {
        if (this.windowPublicNavigationalStateUpdate != null && this.updates != null) {
            for (Map.Entry<String, Serializable> entry : this.windowPublicNavigationalStateUpdate.entrySet()) {
                WindowNavigationalState wns = this.updates.get(entry.getKey());
                if (wns == null) {
                    Window window = this.controllerContext.getWindow(entry.getKey());
                    String windowId = window.getId().toString();
                    wns = this.navigationalStateContext.getWindowNavigationalState(windowId);
                }
                if (wns == null) continue;
                HashMap parameters = new HashMap();
                for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                    parameters.put(((QName)entry2.getKey()).toString(), entry2.getValue());
                }
                ParametersStateString pss = ParametersStateString.create(parameters);
                this.updates.put(entry.getKey(), new WindowNavigationalState(wns.getWindowState(), wns.getMode(), wns.getContentState(), (StateString)pss));
            }
            this.windowPublicNavigationalStateUpdate.clear();
        }
        if (this.updates != null) {
            for (Map.Entry<String, Serializable> entry : this.updates.entrySet()) {
                Window window = this.controllerContext.getWindow(entry.getKey());
                WindowNavigationalState wns = (WindowNavigationalState)entry.getValue();
                this.navigationalStateContext.setWindowNavigationalState(window.getId().toString(), wns);
            }
            this.updates.clear();
        }
        if (this.pageUpdates != null) {
            void var2_7;
            PageNavigationalState storedPNS = this.navigationalStateContext.getPageNavigationalState(this.controllerContext.getPageId());
            if (storedPNS != null) {
                HashMap<QName, String[]> hashMap = new HashMap<QName, String[]>(storedPNS.getParameters());
            } else {
                HashMap hashMap = new HashMap();
            }
            for (Map.Entry<QName, String[]> update : this.pageUpdates.entrySet()) {
                String[] value = update.getValue();
                if (value.length == 0) {
                    var2_7.remove(update.getKey());
                    continue;
                }
                var2_7.put(update.getKey(), value);
            }
            this.navigationalStateContext.setPageNavigationalState(this.controllerContext.getPageId(), new PageNavigationalState((Map<QName, String[]>)var2_7));
            this.pageUpdates.clear();
        }
    }

    public Set<String> getPortletWindowIds() {
        return this.controllerContext.getWindowNames();
    }

    public PortletWindowNavigationalState getPortletWindowNavigationalState(String windowName) throws IllegalArgumentException {
        WindowNavigationalState update = null;
        if (this.updates != null) {
            update = this.updates.get(windowName);
        }
        if (update != null) {
            return new PortletWindowNavigationalState(update.getContentState(), update.getMode(), update.getWindowState());
        }
        Window window = this.controllerContext.getWindow(windowName);
        if (window != null) {
            String windowId = window.getId().toString();
            WindowNavigationalState wns = this.navigationalStateContext.getWindowNavigationalState(windowId);
            if (wns != null) {
                return new PortletWindowNavigationalState(wns.getContentState(), wns.getMode(), wns.getWindowState());
            }
            return new PortletWindowNavigationalState(null, window.getInitialMode(), window.getInitialWindowState());
        }
        return null;
    }

    public void setPortletWindowNavigationalState(String windowName, PortletWindowNavigationalState windowNavigationalState) throws IllegalArgumentException, IllegalStateException {
        if (!this.mutable) {
            throw new IllegalStateException();
        }
        Window window = this.controllerContext.getWindow(windowName);
        if (window != null) {
            if (this.updates == null) {
                this.updates = new HashMap<String, WindowNavigationalState>();
            }
            this.updates.put(windowName, new WindowNavigationalState(windowNavigationalState.getWindowState(), windowNavigationalState.getMode(), windowNavigationalState.getPortletNavigationalState(), null));
        }
    }

    public void setWindowPublicNavigationalState(String windowName, QName name, String[] value) throws IllegalArgumentException, IllegalStateException {
        if (!this.mutable) {
            throw new IllegalStateException();
        }
        if (this.windowPublicNavigationalStateUpdate == null) {
            this.initiateWindowPublicNavigationalStateUpdate();
        }
        if (this.windowPublicNavigationalStateUpdate.get(windowName) == null) {
            this.windowPublicNavigationalStateUpdate.put(windowName, new HashMap());
        }
        this.windowPublicNavigationalStateUpdate.get(windowName).put(name, value);
    }

    public String[] getWindowPublicNavigationalState(String windowName, QName name) throws IllegalArgumentException, IllegalStateException {
        ParametersStateString pss;
        Window window;
        WindowNavigationalState wns;
        String[] value = null;
        if (this.windowPublicNavigationalStateUpdate != null && this.windowPublicNavigationalStateUpdate.get(windowName) != null) {
            value = this.windowPublicNavigationalStateUpdate.get(windowName).get(name);
        }
        if (value == null && (wns = this.navigationalStateContext.getWindowNavigationalState((window = this.controllerContext.getWindow(windowName)).getId().toString())) != null && (pss = (ParametersStateString)wns.getPublicContentState()) != null) {
            value = pss.getValues(name.toString());
        }
        return value != null && value.length > 0 ? value : null;
    }

    public Map<String, String[]> getPortletPublicNavigationalState(String windowName) throws IllegalArgumentException {
        PortletInfo info = this.controllerContext.getPortletInfo(windowName);
        CoordinationManager manager = this.getCoordinationManager();
        if (this.windowPublicNavigationalStateUpdate == null) {
            this.initiateWindowPublicNavigationalStateUpdate();
        }
        if (info != null && info.getNavigation() != null) {
            HashMap<String, String[]> publicNavigationalState = new HashMap<String, String[]>();
            for (ParameterInfo parameterInfo : info.getNavigation().getPublicParameters()) {
                String[] parameterValue;
                Collection<String> bindings = manager.getBindingNames(this.getWindow(windowName), parameterInfo.getName());
                if (CoreConstants.JBOSS_PORTAL_CONTENT_URI.equals(parameterInfo.getName()) || !this.implicitMode && bindings.size() == 0) {
                    parameterValue = this.getWindowPublicNavigationalState(windowName, parameterInfo.getName());
                    if (parameterValue == null) continue;
                    String parameterId = parameterInfo.getId();
                    publicNavigationalState.put(parameterId, (String[])parameterValue.clone());
                    continue;
                }
                parameterValue = this.getPublicNavigationalState(parameterInfo.getName());
                String[] explicitParameterValue = null;
                for (String binding : bindings) {
                    explicitParameterValue = this.getPublicNavigationalState(new QName("", binding));
                }
                String parameterId = parameterInfo.getId();
                if (explicitParameterValue != null) {
                    publicNavigationalState.put(parameterId, (String[])explicitParameterValue.clone());
                    continue;
                }
                if (!this.implicitMode || parameterValue == null) continue;
                publicNavigationalState.put(parameterId, (String[])parameterValue.clone());
            }
            return publicNavigationalState;
        }
        return null;
    }

    public String getPublicNavigationalParameterId(String windowName, QName name) {
        PortletInfo info = this.controllerContext.getPortletInfo(windowName);
        if (info != null) {
            for (ParameterInfo parameterInfo : info.getNavigation().getPublicParameters()) {
                if (!parameterInfo.getName().equals(name)) continue;
                return parameterInfo.getId();
            }
        }
        return null;
    }

    public void setPortletPublicNavigationalState(String windowName, Map<String, String[]> update) {
        if (!this.mutable) {
            throw new IllegalStateException("The page navigational state is not modifiable");
        }
        CoordinationManager manager = this.getCoordinationManager();
        PortletInfo info = this.controllerContext.getPortletInfo(windowName);
        if (info != null) {
            Window window = this.getWindow(windowName);
            NavigationInfo navigationInfo = info.getNavigation();
            for (Map.Entry<String, String[]> entry : update.entrySet()) {
                String id = entry.getKey();
                ParameterInfo parameterInfo = navigationInfo.getPublicParameter(id);
                if (parameterInfo == null) continue;
                QName name = parameterInfo.getName();
                String[] value = entry.getValue();
                Collection<String> bindings = manager.getBindingNames(window, name);
                if (CoreConstants.JBOSS_PORTAL_CONTENT_URI.equals(name) || !this.implicitMode && bindings.size() == 0) {
                    if (value.length > 0) {
                        this.setWindowPublicNavigationalState(windowName, name, value);
                        continue;
                    }
                    this.setWindowPublicNavigationalState(windowName, name, REMOVAL);
                    continue;
                }
                if (this.implicitMode) {
                    if (value.length > 0) {
                        this.setPublicNavigationalState(name, value);
                    } else {
                        this.removePublicNavigationalState(name);
                    }
                }
                for (String binding : bindings) {
                    this.setPublicNavigationalState(new QName("", binding), value);
                }
            }
        }
    }

    public Set<QName> getPublicNames() {
        if (this.pageUpdates == null) {
            return Collections.emptySet();
        }
        return this.pageUpdates.keySet();
    }

    public String[] getPublicNavigationalState(QName name) throws IllegalArgumentException {
        PageNavigationalState storedPNS;
        String[] value = null;
        if (this.pageUpdates != null) {
            value = this.pageUpdates.get(name);
        }
        if (value == null && (storedPNS = this.navigationalStateContext.getPageNavigationalState(this.controllerContext.getPageId())) != null) {
            value = storedPNS.getParameter(name);
        }
        return value != null && value.length > 0 ? value : null;
    }

    public void setPublicNavigationalState(QName name, String[] value) throws IllegalArgumentException, IllegalStateException {
        if (!this.mutable) {
            throw new IllegalStateException();
        }
        if (this.pageUpdates == null) {
            this.pageUpdates = new HashMap<QName, String[]>();
        }
        this.pageUpdates.put(name, value);
    }

    public void removePublicNavigationalState(QName name) throws IllegalArgumentException, IllegalStateException {
        if (!this.mutable) {
            throw new IllegalStateException();
        }
        if (this.pageUpdates == null) {
            this.pageUpdates = new HashMap<QName, String[]>();
        }
        this.pageUpdates.put(name, REMOVAL);
    }

    public HashMap<QName, String[]> getWindowPublicContentStateParameters(String windowName) {
        ParametersStateString pss;
        HashMap<QName, String[]> params = new HashMap<QName, String[]>();
        Window window = this.getWindow(windowName);
        WindowNavigationalState wns = this.navigationalStateContext.getWindowNavigationalState(window.getId().toString());
        if (wns != null && (pss = (ParametersStateString)wns.getPublicContentState()) != null) {
            for (Map.Entry entry : pss.getParameters().entrySet()) {
                params.put(QName.valueOf((String)entry.getKey()), (String[])entry.getValue());
            }
        }
        return params;
    }

    private void initiateWindowPublicNavigationalStateUpdate() throws IllegalStateException {
        if (this.windowPublicNavigationalStateUpdate != null) {
            return;
        }
        this.windowPublicNavigationalStateUpdate = new Hashtable<String, HashMap<QName, String[]>>();
        for (String windowName : this.controllerContext.getWindowNames()) {
            HashMap<QName, String[]> publicContentStateParams = this.getWindowPublicContentStateParameters(windowName);
            this.windowPublicNavigationalStateUpdate.put(windowName, publicContentStateParams);
        }
    }

    public Window getWindow(String windowName) {
        return this.controllerContext.getWindow(windowName);
    }

    public CoordinationManager getCoordinationManager() {
        return this.controllerContext.getControllerContext().getController().getCoordinationManager();
    }
}

