/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.portal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.portal.common.NotYetImplemented;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.core.impl.model.portal.ObjectNode;
import org.jboss.portal.core.model.portal.DuplicatePortalObjectException;
import org.jboss.portal.core.model.portal.NoSuchPortalObjectException;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortalObjectImpl
implements PortalObject {
    protected static final int ALL_TYPES_MASK = 15;
    private Long key;
    private Map<String, String> declaredPropertyMap = new HashMap<String, String>();
    private String listener = null;
    private Map displayNames;
    private ObjectNode objectNode;
    private Map properties = null;
    private Map unmodifiableProperties = null;
    private SortedSet accessedChildren = null;

    public PortalObjectImpl() {
        this(true);
    }

    public PortalObjectImpl(boolean initState) {
    }

    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public ObjectNode getObjectNode() {
        return this.objectNode;
    }

    public void setObjectNode(ObjectNode objectNode) {
        this.objectNode = objectNode;
    }

    @Override
    public PortalObjectId getId() {
        return this.objectNode.getPath();
    }

    public int compareTo(Object o) {
        PortalObject po = (PortalObject)o;
        return this.getId().compareTo(po.getId());
    }

    @Override
    public void destroyChild(String name) throws NoSuchPortalObjectException {
        this.objectNode.removeChild(name);
    }

    @Override
    public String getName() {
        return this.objectNode.getName();
    }

    public void setDisplayNames(Map displayNames) {
        this.displayNames = displayNames;
    }

    public Map getDisplayNames() {
        return this.displayNames;
    }

    @Override
    public void setDisplayName(LocalizedString displayName) {
        if (displayName == null) {
            throw new IllegalArgumentException("No null display name accepted");
        }
        this.displayNames = new HashMap();
        Map map = displayName.getValues();
        for (LocalizedString.Value value : map.values()) {
            this.displayNames.put(value.getLocale(), value.getString());
        }
    }

    @Override
    public LocalizedString getDisplayName() {
        if (this.displayNames != null) {
            return new LocalizedString(this.displayNames, Locale.ENGLISH);
        }
        return null;
    }

    @Override
    public PortalObject copy(PortalObject parent, String name, boolean deep) throws DuplicatePortalObjectException, IllegalArgumentException {
        if (parent == null) {
            throw new IllegalArgumentException("No null parent accepted");
        }
        if (name == null) {
            throw new IllegalArgumentException("No null name accepted");
        }
        return this.copy((PortalObjectImpl)parent, name, deep);
    }

    public Collection getChildren() {
        return this.getChildren(15);
    }

    private boolean isMatchingMask(PortalObjectImpl object, int mask) {
        return mask == 15 || (object.getMask() & mask) != 0;
    }

    public Collection getChildren(int wantedMask) {
        int mask = wantedMask & 0xF;
        return new ChildrenCollection(mask, this.objectNode.getChildren());
    }

    @Override
    public String getListener() {
        return this.listener;
    }

    @Override
    public void setListener(String listener) {
        this.listener = listener;
    }

    @Override
    public PortalObject getParent() {
        if (this.objectNode.getParent() != null) {
            return this.objectNode.getParent().getObject();
        }
        return null;
    }

    @Override
    public PortalObject getChild(String name) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"child name");
        PortalObject portalObject = this.objectNode.getContext().getContainer().getObject(this.getId().getChildId(name));
        if (portalObject != null) {
            this.getAccessedChildren().add(portalObject);
            return portalObject;
        }
        return null;
    }

    @Override
    public <T extends PortalObject> T getChild(String name, Class<T> expectedType) {
        ParameterValidation.throwIllegalArgExceptionIfNull(expectedType, (String)"expected type");
        PortalObject child = this.getChild(name);
        if (expectedType.isInstance(child)) {
            return (T)((PortalObject)expectedType.cast(child));
        }
        return null;
    }

    private Set getAccessedChildren() {
        if (this.accessedChildren == null) {
            this.accessedChildren = new TreeSet();
        }
        return this.accessedChildren;
    }

    public Map getProperties() {
        if (this.properties == null) {
            ObjectNode parent = this.objectNode.getParent();
            if (parent == null) {
                this.properties = this.declaredPropertyMap;
            } else {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.putAll(parent.getObject().getProperties());
                properties.putAll(this.declaredPropertyMap);
                this.properties = properties;
            }
            this.unmodifiableProperties = Collections.unmodifiableMap(this.properties);
        }
        return this.unmodifiableProperties;
    }

    public Map<String, String> getDeclaredPropertyMap() {
        return this.declaredPropertyMap;
    }

    public void setDeclaredPropertyMap(Map<String, String> properties) {
        this.declaredPropertyMap = properties;
    }

    @Override
    public Map<String, String> getDeclaredProperties() {
        return Collections.unmodifiableMap(this.declaredPropertyMap);
    }

    @Override
    public String getDeclaredProperty(String name) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"property name");
        return this.declaredPropertyMap.get(name);
    }

    @Override
    public void setDeclaredProperty(String name, String value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"property name");
        if (value == null) {
            this.declaredPropertyMap.remove(name);
            PortalObject parent = this.getParent();
            String parentValue = null;
            if (parent != null) {
                parentValue = parent.getProperty(name);
            }
            this.propagatePropertyUpdate(name, parentValue, true);
        } else {
            this.declaredPropertyMap.put(name, value);
            this.propagatePropertyUpdate(name, value, true);
        }
    }

    private void propagatePropertyUpdate(String name, String value, boolean force) {
        if (this.properties != null && (force || !this.declaredPropertyMap.containsKey(name))) {
            if (value == null) {
                this.properties.remove(name);
            } else {
                this.properties.put(name, value);
            }
            if (this.accessedChildren != null) {
                for (PortalObjectImpl child : this.accessedChildren) {
                    child.propagatePropertyUpdate(name, value, false);
                }
            }
        }
    }

    @Override
    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Map properties = this.getProperties();
        return (String)properties.get(name);
    }

    @Override
    public abstract int getType();

    public String toString() {
        return this.objectNode.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PortalObjectImpl) {
            PortalObjectImpl that = (PortalObjectImpl)obj;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    protected PortalObject getDefaultChild() {
        String portalName = this.getDeclaredProperty("portal.defaultObjectName");
        if (portalName == null) {
            portalName = "default";
        }
        return this.getChild(portalName);
    }

    protected abstract PortalObjectImpl cloneObject();

    protected void destroy() {
    }

    protected final int getMask() {
        return this.getMask(this.getType());
    }

    protected final int getMask(int portalObjectType) {
        switch (portalObjectType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Unknown type " + portalObjectType);
    }

    protected final void addChild(String name, PortalObjectImpl childObject) throws DuplicatePortalObjectException, IllegalArgumentException {
        this.objectNode.addChild(name, childObject);
        this.getAccessedChildren().add(childObject);
    }

    private PortalObjectImpl copy(PortalObjectImpl parent, String name, boolean deep) throws DuplicatePortalObjectException {
        PortalObjectImpl clone = this.cloneObject();
        parent.addChild(name, clone);
        if (deep) {
            for (PortalObjectImpl child : this.getChildren()) {
                child.copy(clone, child.getName(), true);
            }
        }
        return clone;
    }

    private class ChildrenCollection
    implements Collection {
        private final int mask;
        private final SortedMap children;

        public ChildrenCollection(int mask, Map children) {
            this.mask = mask;
            this.children = new TreeMap(children);
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection c) {
            throw new NotYetImplemented();
        }

        public boolean contains(Object o) {
            throw new NotYetImplemented();
        }

        public boolean isEmpty() {
            return this.children.isEmpty();
        }

        public int size() {
            if (this.mask != 15) {
                int count = 0;
                for (Object object : this.children.values()) {
                    ObjectNode childNode = (ObjectNode)object;
                    PortalObjectImpl childObject = childNode.getObject();
                    if (!PortalObjectImpl.this.isMatchingMask(childObject, this.mask)) continue;
                    ++count;
                }
                return count;
            }
            return this.children.size();
        }

        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        public Iterator iterator() {
            return new ChildrenIterator();
        }

        public Object[] toArray(Object[] a) {
            ArrayList tmp = new ArrayList(this.children.size());
            for (Object child : this) {
                tmp.add(child);
            }
            return tmp.toArray(a);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(512);
            sb.append("[");
            for (Object o : this) {
                sb.append(" ").append(o);
            }
            sb.append(" ]");
            return sb.toString();
        }

        private class ChildrenIterator
        implements Iterator {
            private final Iterator iterator;
            private PortalObject nextChild = null;

            public ChildrenIterator() {
                this.iterator = ChildrenCollection.this.children.values().iterator();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                if (this.nextChild == null) {
                    while (this.nextChild == null && this.iterator.hasNext()) {
                        ObjectNode childNode = (ObjectNode)this.iterator.next();
                        PortalObjectImpl childObject = childNode.getObject();
                        if (!PortalObjectImpl.this.isMatchingMask(childObject, ChildrenCollection.this.mask)) continue;
                        this.nextChild = childObject;
                    }
                }
                return this.nextChild != null;
            }

            public Object next() {
                if (this.nextChild == null) {
                    this.hasNext();
                }
                if (this.nextChild == null) {
                    throw new NoSuchElementException();
                }
                PortalObjectImpl.this.getAccessedChildren().add(this.nextChild);
                PortalObject nextChild = this.nextChild;
                this.nextChild = null;
                return nextChild;
            }
        }
    }
}

