/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal;

import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.command.mapper.AbstractCommandFactory;
import org.jboss.portal.core.controller.command.mapper.CommandFactory;
import org.jboss.portal.core.model.portal.Context;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.command.view.ViewPageCommand;
import org.jboss.portal.server.ServerInvocation;

public class DefaultPortalCommandFactory
extends AbstractCommandFactory {
    private CommandFactory nextFactory;
    private PortalObjectContainer container;

    public PortalObjectContainer getContainer() {
        return this.container;
    }

    public void setContainer(PortalObjectContainer container) {
        this.container = container;
    }

    public CommandFactory getNextFactory() {
        return this.nextFactory;
    }

    public void setNextFactory(CommandFactory nextFactory) {
        this.nextFactory = nextFactory;
    }

    public ControllerCommand doMapping(ControllerContext controllerContext, ServerInvocation invocation, String host, String contextPath, String requestPath) {
        ControllerCommand cmd = this.nextFactory.doMapping(controllerContext, invocation, host, contextPath, requestPath);
        if (cmd == null) {
            Context context = this.container.getContext();
            if (context == null) {
                throw new IllegalStateException("Context does not exist");
            }
            Portal portal = context.getDefaultPortal();
            if (portal == null) {
                throw new IllegalStateException("Default portal does not exist");
            }
            Page page = portal.getDefaultPage();
            if (page == null) {
                throw new IllegalStateException("Default page does not exist");
            }
            PortalObjectId id = page.getId();
            cmd = new ViewPageCommand(id);
        }
        return cmd;
    }
}

