/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.faces;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import javax.faces.model.SelectItem;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.jboss.logging.Logger;
import org.jboss.portal.common.reflect.Modifier;
import org.jboss.portal.core.identity.services.metadata.UIComponentConfiguration;
import org.jboss.portal.core.identity.ui.faces.components.StaticValues;
import org.jboss.portal.faces.el.PropertyValue;
import org.jboss.portal.faces.el.decorator.BeanDecorator;
import org.jboss.portal.faces.el.dynamic.DynamicBean;

public class PortletDelegatingPropertyResolver
extends PropertyResolver {
    private PropertyResolver delegate;
    private volatile Map decoratorMap = new HashMap();
    private static final Logger log = Logger.getLogger(PortletDelegatingPropertyResolver.class);

    public PortletDelegatingPropertyResolver(PropertyResolver delegate) {
        this.delegate = delegate;
    }

    public Class getType(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof PortletPreferences) {
            throw new PropertyNotFoundException("PortletPreferences can not be accessed via an index");
        }
        return this.delegate.getType(base, index);
    }

    public Class getType(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        DynamicBean dynamicBean;
        Class type;
        if (base instanceof PortletPreferences) {
            return String.class;
        }
        if (base instanceof DynamicBean && (type = (dynamicBean = (DynamicBean)base).getType(property)) != null) {
            return type;
        }
        GetTypeBeanAction beanAction = new GetTypeBeanAction(base, property);
        if (this.resolveAction(base.getClass(), beanAction)) {
            return beanAction.type;
        }
        if (property instanceof String) {
            try {
                Field f = base.getClass().getField((String)property);
                if (Modifier.isReadableProperty((Field)f)) {
                    return f.getType();
                }
            }
            catch (NoSuchFieldException ignore) {
                // empty catch block
            }
        }
        if (this.delegate != null) {
            return this.delegate.getType(base, property);
        }
        throw this.createPNFE(base, property);
    }

    public Object getValue(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof PortletPreferences) {
            throw new PropertyNotFoundException("PortletPreferences can not be accessed via an index");
        }
        return this.delegate.getValue(base, index);
    }

    public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        DynamicBean dynamicBean;
        PropertyValue value;
        if (base instanceof UIComponentConfiguration && ((String)property).equals("values")) {
            ArrayList<SelectItem> list = new ArrayList<SelectItem>();
            FacesContext ctx = FacesContext.getCurrentInstance();
            UIComponentConfiguration uiComponent = (UIComponentConfiguration)base;
            if (!uiComponent.isRequired()) {
                list.add(new SelectItem((Object)""));
            }
            if ("org.jboss.portal.core.identity.locale".equals(uiComponent.getPredefinedMapValues())) {
                list.addAll(StaticValues.getLocale(ctx));
                return list;
            }
            if ("org.jboss.portal.core.identity.theme".equals(uiComponent.getPredefinedMapValues())) {
                list.addAll(StaticValues.getTheme(ctx));
                return list;
            }
            if ("org.jboss.portal.core.identity.timezone".equals(uiComponent.getPredefinedMapValues())) {
                list.addAll(StaticValues.getTimezone());
                return list;
            }
            for (String key : uiComponent.getValues().keySet()) {
                String value2 = (String)uiComponent.getValues().get(key);
                ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", ctx.getViewRoot().getLocale());
                try {
                    value2 = bundle.getString("IDENTITY_DYNAMIC_VALUE_" + key.toUpperCase());
                }
                catch (Exception e) {
                    // empty catch block
                }
                list.add(new SelectItem((Object)key, value2));
            }
            return list;
        }
        if (base instanceof PortletPreferences) {
            PortletPreferences preferences = (PortletPreferences)base;
            return preferences.getValue((String)property, null);
        }
        if (base instanceof DynamicBean && (value = (dynamicBean = (DynamicBean)base).getValue(property)) != null) {
            return value.getObject();
        }
        GetValueBeanAction beanAction = new GetValueBeanAction(base, property);
        if (this.resolveAction(base.getClass(), beanAction)) {
            return beanAction.value.getObject();
        }
        if (property instanceof String) {
            try {
                Field f = base.getClass().getField((String)property);
                if (Modifier.isReadableProperty((Field)f)) {
                    return f.get(base);
                }
            }
            catch (NoSuchFieldException ignore) {
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Was not able to read the field " + property + " of object " + base + " with class " + base.getClass().getName()));
            }
        }
        if (this.delegate != null) {
            return this.delegate.getValue(base, property);
        }
        throw this.createPNFE(base, property);
    }

    public boolean isReadOnly(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof PortletPreferences) {
            throw new PropertyNotFoundException("PortletPreferences can not be accessed via an index");
        }
        return this.delegate.isReadOnly(base, index);
    }

    public boolean isReadOnly(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof PortletPreferences) {
            PortletPreferences preferences = (PortletPreferences)base;
            return preferences.isReadOnly((String)property);
        }
        return this.delegate.isReadOnly(base, property);
    }

    public void setValue(Object base, int index, Object value) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof PortletPreferences) {
            throw new PropertyNotFoundException("PortletPreferces can not be accessed via an index");
        }
        this.delegate.setValue(base, index, value);
    }

    public void setValue(Object base, Object property, Object value) throws EvaluationException, PropertyNotFoundException {
        DynamicBean dynamic;
        if (base instanceof PortletPreferences) {
            PortletPreferences preferences = (PortletPreferences)base;
            try {
                preferences.setValue((String)property, (String)value);
            }
            catch (ReadOnlyException e) {
                log.error((Object)("PortletPreference " + (String)property + " read only"), (Throwable)e);
            }
        }
        if (base instanceof DynamicBean && (dynamic = (DynamicBean)base).setValue(property, value)) {
            return;
        }
        SetValueBeanAction beanAction = new SetValueBeanAction(base, property, value);
        if (this.resolveAction(base.getClass(), beanAction)) {
            return;
        }
        if (property instanceof String) {
            try {
                Field f = base.getClass().getField((String)property);
                if (Modifier.isWritableProperty((Field)f)) {
                    f.set(base, value);
                    return;
                }
            }
            catch (NoSuchFieldException ignore) {
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Was not able to write the field " + property + " of object " + base + " with class " + base.getClass().getName()));
            }
        }
        if (this.delegate != null) {
            this.delegate.setValue(base, property, value);
            return;
        }
        throw this.createPNFE(base, property);
    }

    public final synchronized void registerDecorator(Class clazz, BeanDecorator decorator) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (decorator == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, BeanDecorator> copy = new HashMap<String, BeanDecorator>(this.decoratorMap);
        copy.put(clazz.getName(), decorator);
        this.decoratorMap = copy;
        log.debug((Object)("Added bean decorator " + clazz.getName() + " in resolver map"));
    }

    private boolean resolveAction(Class clazz, BeanAction action) {
        BeanDecorator decorator = (BeanDecorator)this.decoratorMap.get(clazz.getName());
        if (decorator != null && action.execute(decorator)) {
            return true;
        }
        Class<?>[] itfs = clazz.getInterfaces();
        for (int i = 0; i < itfs.length; ++i) {
            Class<?> itf = clazz.getInterfaces()[i];
            if (!this.resolveAction(itf, action)) continue;
            return true;
        }
        Class superClass = clazz.getSuperclass();
        return superClass != null && this.resolveAction(superClass, action);
    }

    private PropertyNotFoundException createPNFE(Object base, int index) {
        return this.createPNFE(base, "[" + index + "]");
    }

    private PropertyNotFoundException createPNFE(Object base, Object propertyName) {
        return new PropertyNotFoundException("Property " + propertyName + " on object " + base + " was not found");
    }

    private static class SetValueBeanAction
    extends AbstractBeanAction {
        private Object value;

        public SetValueBeanAction(Object base, Object property, Object value) {
            super(base, property);
            this.value = value;
        }

        public boolean execute(BeanDecorator decorator) {
            return decorator.setValue(this.base, this.property, this.value);
        }
    }

    private static class GetValueBeanAction
    extends AbstractBeanAction {
        private PropertyValue value;

        public GetValueBeanAction(Object base, Object property) {
            super(base, property);
        }

        public boolean execute(BeanDecorator decorator) {
            this.value = decorator.getValue(this.base, this.property);
            return this.value != null;
        }
    }

    private static class GetTypeBeanAction
    extends AbstractBeanAction {
        private Class type;

        public GetTypeBeanAction(Object base, Object property) {
            super(base, property);
        }

        public boolean execute(BeanDecorator decorator) {
            this.type = decorator.getType(this.base, this.property);
            return this.type != null;
        }
    }

    private static abstract class AbstractBeanAction
    implements BeanAction {
        protected final Object base;
        protected final Object property;

        public AbstractBeanAction(Object base, Object property) {
            this.base = base;
            this.property = property;
        }
    }

    private static interface BeanAction {
        public boolean execute(BeanDecorator var1);
    }
}

