/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.container;

import org.jboss.portal.portlet.container.PortletContainer;
import org.jboss.portal.portlet.container.PortletContainerContext;
import org.jboss.portal.portlet.container.managed.LifeCycleStatus;
import org.jboss.portal.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.jboss.portal.portlet.container.managed.ManagedPortletContainer;
import org.jboss.portal.portlet.container.object.PortletContainerObject;
import org.jboss.portal.portlet.impl.container.DependencyNotResolvedException;
import org.jboss.portal.portlet.impl.container.LifeCycle;
import org.jboss.portal.portlet.impl.container.PortletApplicationLifeCycle;
import org.jboss.portal.portlet.impl.container.PortletFilterLifeCycle;
import org.jboss.portal.portlet.info.PortletInfo;

public class PortletContainerLifeCycle
extends LifeCycle
implements ManagedPortletContainer {
    private PortletApplicationLifeCycle portletApplicationLifeCycle;
    final PortletContainerContext portletContainerContext;
    final PortletContainerObject portletContainer;

    PortletContainerLifeCycle(PortletApplicationLifeCycle portletApplicationLifeCycle, PortletContainerContext portletContainerContext, PortletContainerObject portletContainer) {
        this.portletApplicationLifeCycle = portletApplicationLifeCycle;
        this.portletContainerContext = portletContainerContext;
        this.portletContainer = portletContainer;
    }

    protected void invokeStart() throws Exception {
        if (this.portletApplicationLifeCycle.getStatus() != LifeCycleStatus.STARTED) {
            throw new DependencyNotResolvedException("The parent application is not started");
        }
        for (PortletFilterLifeCycle portletFilterLifeCycle : this.portletApplicationLifeCycle.getDependencies(this)) {
            if (portletFilterLifeCycle.getStatus() == LifeCycleStatus.STARTED) continue;
            throw new DependencyNotResolvedException("The filter " + portletFilterLifeCycle + " is not started");
        }
        this.portletContainer.start();
    }

    protected void invokeStop() {
        this.portletContainer.stop();
    }

    public String getId() {
        return this.portletContainer.getId();
    }

    public PortletInfo getInfo() {
        return this.portletContainer.getInfo();
    }

    public PortletApplicationLifeCycle getManagedPortletApplication() {
        return this.portletApplicationLifeCycle;
    }

    public String toString() {
        return "PortletContainerLifeCycle[" + this.portletContainer.getId() + "]";
    }

    public PortletContainer getPortletContainer() {
        return this.portletContainer;
    }

    protected ManagedObjectRegistryEventListener getListener() {
        return this.portletApplicationLifeCycle.getListener();
    }
}

