/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.services.impl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.core.identity.services.IdentityMailService;
import org.jboss.portal.core.identity.services.metadata.IdentityUIConfiguration;
import org.jboss.portal.core.identity.services.metadata.IdentityUIConfigurationService;
import org.jboss.portal.core.modules.MailModule;
import org.jboss.portal.jems.as.JNDI;
import org.jboss.portal.jems.as.system.AbstractJBossService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityMailServiceImpl
extends AbstractJBossService
implements IdentityMailService {
    private String emailDomain = null;
    private String emailFrom = null;
    private MailModule mailModule;
    private static final String TEMPLATE_PATH = "conf/templates/";
    private static final String TEMPLATE_PREFIX = "/emailTemplate";
    private IdentityUIConfigurationService identityUIConfigurationService;
    public static final String UNKOWN_ACTION_PREFIX = "IDENTITY_MAIL_SUBJECT_CUSTOM_";
    private static final Logger log = Logger.getLogger(IdentityMailServiceImpl.class);
    private JNDI.Binding jndiBinding;
    private String jndiName = null;

    public void startService() throws Exception {
        super.startService();
        IdentityUIConfiguration cf = this.identityUIConfigurationService.getConfiguration();
        this.setEmailDomain(cf.getEmailDomain());
        this.setEmailFrom(cf.getEmailFrom());
        if (this.jndiName != null) {
            this.jndiBinding = new JNDI.Binding(this.jndiName, (Object)this);
            this.jndiBinding.bind();
        }
    }

    public void stopService() throws Exception {
        super.stopService();
        if (this.jndiBinding != null) {
            this.jndiBinding.unbind();
            this.jndiBinding = null;
        }
    }

    public String getEmailDomain() {
        return this.emailDomain;
    }

    public void setEmailDomain(String emailDomain) {
        if (emailDomain == null) {
            throw new IllegalArgumentException("email domain may not be null.");
        }
        this.emailDomain = emailDomain;
    }

    public String getEmailFrom() {
        return this.emailFrom;
    }

    public void setEmailFrom(String emailFrom) {
        if (emailFrom == null) {
            throw new IllegalArgumentException("email from may not be null.");
        }
        this.emailFrom = emailFrom;
    }

    public MailModule getMailModule() {
        return this.mailModule;
    }

    public void setMailModule(MailModule mailModule) {
        this.mailModule = mailModule;
    }

    public IdentityUIConfigurationService getIdentityUIConfigurationService() {
        return this.identityUIConfigurationService;
    }

    public void setIdentityUIConfigurationService(IdentityUIConfigurationService identityUIConfigurationService) {
        this.identityUIConfigurationService = identityUIConfigurationService;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    @Override
    public void sendMail(String templateLocation, Map<String, String> mailData, Locale locale) throws IOException, TemplateException {
        if (templateLocation == null) {
            throw new IllegalArgumentException("template location may not be null.");
        }
        if (mailData == null) {
            throw new IllegalArgumentException("mail data may not be null.");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale may not be null.");
        }
        mailData.put("emailDomain", this.emailDomain);
        ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", locale);
        String subject = null;
        String to = mailData.get("to");
        if ("register".equals(templateLocation)) {
            subject = bundle.getString("IDENTITY_MAIL_SUBJECT_REGISTER");
        } else if ("changeEmail".equals(templateLocation)) {
            subject = bundle.getString("IDENTITY_MAIL_SUBJECT_CHANGE_EMAIL");
        } else if ("lostPassword".equals(templateLocation)) {
            subject = bundle.getString("IDENTITY_MAIL_SUBJECT_LOST_PASSWORD");
        } else {
            subject = bundle.getString(UNKOWN_ACTION_PREFIX + templateLocation);
            if (subject == null) {
                throw new IllegalArgumentException("No custom mail subject found (Unknown Template). ");
            }
        }
        String emailText = this.generateEmailText(templateLocation, mailData, locale);
        this.send(this.emailFrom, to, subject, emailText);
    }

    @Override
    public void send(String emailFrom, String emailTo, String subject, String emailText) {
        if (emailFrom == null) {
            throw new IllegalArgumentException("email-from may not be null.");
        }
        if (emailTo == null) {
            throw new IllegalArgumentException("email-to may not be null.");
        }
        if (subject == null) {
            throw new IllegalArgumentException("email-subject may not be null.");
        }
        this.getMailModule().send(emailFrom, emailTo, subject, emailText);
    }

    private String generateEmailText(String templateLocation, Map<String, String> mailData, Locale locale) throws IOException, TemplateException {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        URL config = tcl.getResource(TEMPLATE_PATH + templateLocation + TEMPLATE_PREFIX + "_" + locale.getLanguage() + "_" + locale.getCountry() + ".tpl");
        if (config == null) {
            config = tcl.getResource(TEMPLATE_PATH + templateLocation + TEMPLATE_PREFIX + "_" + locale.getLanguage() + ".tpl");
        }
        if (config == null) {
            config = tcl.getResource(TEMPLATE_PATH + templateLocation + TEMPLATE_PREFIX + ".tpl");
        }
        if (config == null) {
            throw new FileNotFoundException("Cannot load a suitable email template in: conf/templates/");
        }
        InputStream in = config.openStream();
        Template tpl = new Template("emailTemplate", (Reader)new InputStreamReader(in), new Configuration());
        StringWriter out = new StringWriter();
        tpl.process(mailData, (Writer)out);
        IOTools.safeClose((Closeable)out);
        return out.toString();
    }
}

