/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.services.dao;

import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.IDAO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.locator.Locator;

public final class DocumentDAO
implements IDAO<Document, DocumentDTO> {
    private static final String NUXEO_DATE_REGEX = "[\\-0-9]+T[:\\.0-9]+Z";
    private static DocumentDAO instance;
    private final INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
    private final Pattern datePattern = Pattern.compile("[\\-0-9]+T[:\\.0-9]+Z");

    private DocumentDAO() {
    }

    public static DocumentDAO getInstance() {
        if (instance == null) {
            instance = new DocumentDAO();
        }
        return instance;
    }

    @Override
    public DocumentDTO toDTO(Document document) {
        DocumentDTO dto = new DocumentDTO();
        dto.setId(document.getId());
        dto.setTitle(document.getTitle());
        dto.setPath(document.getPath());
        dto.setType(this.getType(document.getType()));
        Map<String, Object> properties = dto.getProperties();
        properties.putAll(this.toMap(document.getProperties()));
        dto.setDocument(document);
        return dto;
    }

    private List<Object> toList(PropertyList propertyList) {
        ArrayList<Object> list = new ArrayList<Object>(propertyList.size());
        int index = 0;
        for (Object object : propertyList.list()) {
            if (object instanceof PropertyMap) {
                PropertyMap propertyMapValue = (PropertyMap)object;
                list.add(this.toMap(propertyMapValue));
            } else if (object instanceof PropertyList) {
                PropertyList propertyListValue = (PropertyList)object;
                list.add(this.toList(propertyListValue));
            } else if (object instanceof String) {
                String stringValue = (String)object;
                Matcher dateMatcher = this.datePattern.matcher(stringValue);
                if (dateMatcher.matches()) {
                    Date date = propertyList.getDate(index);
                    list.add(date);
                } else {
                    list.add(stringValue);
                }
            } else {
                list.add(object);
            }
            ++index;
        }
        return list;
    }

    private Map<String, Object> toMap(PropertyMap propertyMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(propertyMap.size());
        for (Map.Entry entry : propertyMap.map().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof PropertyMap) {
                PropertyMap propertyMapValue = (PropertyMap)value;
                map.put(key, this.toMap(propertyMapValue));
                continue;
            }
            if (value instanceof PropertyList) {
                PropertyList propertyListValue = (PropertyList)value;
                map.put(key, this.toList(propertyListValue));
                continue;
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                Matcher dateMatcher = this.datePattern.matcher(stringValue);
                if (dateMatcher.matches()) {
                    Date date = propertyMap.getDate(key);
                    map.put(key, date);
                    continue;
                }
                map.put(key, stringValue);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    private DocumentType getType(String type) {
        INuxeoCustomizer cmsCustomizer = this.nuxeoService.getCMSCustomizer();
        Map<String, DocumentType> types = cmsCustomizer.getCMSItemTypes();
        return types.get(type);
    }
}

