/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.reflect.plugins.ClassInfoImpl;
import org.jboss.reflect.plugins.ConstructorInfoImpl;
import org.jboss.reflect.plugins.FieldInfoImpl;
import org.jboss.reflect.plugins.InterfaceInfoImpl;
import org.jboss.reflect.plugins.MethodInfoImpl;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.WeakClassCache;

public class IntrospectionTypeInfoFactoryImpl
extends WeakClassCache
implements TypeInfoFactory {
    public void generateTypeInfo(Class clazz, ClassInfoImpl info) {
    }

    public ClassInfo getSuperClass(Class clazz) {
        Class superClazz;
        ClassInfoImpl superType = null;
        if (!clazz.isInterface() && (superClazz = clazz.getSuperclass()) != null) {
            superType = (ClassInfoImpl)this.getTypeInfo(superClazz);
        }
        return superType;
    }

    public AnnotationValue[] getAnnotations(Object obj) {
        return new AnnotationValue[0];
    }

    public ConstructorInfoImpl[] getConstructors(Class clazz, ClassInfo declaring) {
        Constructor[] constructors;
        ConstructorInfoImpl[] infos = null;
        if (!clazz.isInterface() && (constructors = this.getDeclaredConstructors(clazz)) != null && constructors.length > 0) {
            infos = new ConstructorInfoImpl[constructors.length];
            for (int i = 0; i < constructors.length; ++i) {
                AnnotationValue[] annotations = this.getAnnotations(constructors[i]);
                infos[i] = new ConstructorInfoImpl(annotations, this.getTypeInfos(constructors[i].getParameterTypes()), this.getClassInfos(constructors[i].getExceptionTypes()), constructors[i].getModifiers(), (ClassInfo)this.getTypeInfo(constructors[i].getDeclaringClass()));
                infos[i].setConstructor(constructors[i]);
            }
        }
        return infos;
    }

    public FieldInfoImpl[] getFields(Class clazz, ClassInfo declaring) {
        Field[] fields = this.getDeclaredFields(clazz);
        if (fields == null || fields.length == 0) {
            return null;
        }
        FieldInfoImpl[] infos = new FieldInfoImpl[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            AnnotationValue[] annotations = this.getAnnotations(fields[i]);
            infos[i] = new FieldInfoImpl(annotations, fields[i].getName(), this.getTypeInfo(fields[i].getType()), fields[i].getModifiers(), (ClassInfo)this.getTypeInfo(fields[i].getDeclaringClass()));
            infos[i].setField(fields[i]);
        }
        return infos;
    }

    public MethodInfoImpl[] getMethods(Class clazz, ClassInfo declaring) {
        Method[] methods = this.getDeclaredMethods(clazz);
        if (methods == null || methods.length == 0) {
            return null;
        }
        MethodInfoImpl[] infos = new MethodInfoImpl[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            AnnotationValue[] annotations = this.getAnnotations(methods[i]);
            infos[i] = new MethodInfoImpl(annotations, methods[i].getName(), this.getTypeInfo(methods[i].getReturnType()), this.getTypeInfos(methods[i].getParameterTypes()), this.getClassInfos(methods[i].getExceptionTypes()), methods[i].getModifiers(), (ClassInfo)this.getTypeInfo(methods[i].getDeclaringClass()));
            infos[i].setMethod(methods[i]);
        }
        return infos;
    }

    public InterfaceInfo[] getInterfaces(Class clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return null;
        }
        InterfaceInfo[] infos = new InterfaceInfo[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            infos[i] = (InterfaceInfo)this.getTypeInfo(interfaces[i]);
        }
        return infos;
    }

    public TypeInfo[] getTypeInfos(Class[] classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        TypeInfo[] result = new TypeInfo[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            result[i] = this.getTypeInfo(classes[i]);
        }
        return result;
    }

    public ClassInfo[] getClassInfos(Class[] classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        ClassInfo[] result = new ClassInfo[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            result[i] = (ClassInfo)this.getTypeInfo(classes[i]);
        }
        return result;
    }

    public TypeInfo getTypeInfo(Class clazz) {
        PrimitiveInfo primitive = PrimitiveInfo.valueOf(clazz.getName());
        if (primitive != null) {
            return primitive;
        }
        return (TypeInfo)this.get(clazz);
    }

    public TypeInfo getTypeInfo(String name, ClassLoader cl) throws ClassNotFoundException {
        Class<?> clazz = cl.loadClass(name);
        return this.getTypeInfo(clazz);
    }

    protected Object instantiate(Class clazz) {
        ClassInfoImpl result = clazz.isInterface() ? new InterfaceInfoImpl(clazz.getName()) : new ClassInfoImpl(clazz.getName());
        result.setType(clazz);
        result.setTypeInfoFactory(this);
        return result;
    }

    protected void generate(Class clazz, Object result) {
        this.generateTypeInfo(clazz, (ClassInfoImpl)result);
    }

    protected Constructor[] getDeclaredConstructors(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredConstructors();
        }
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredConstructors();
            }
        };
        return (Constructor[])AccessController.doPrivileged(action);
    }

    protected Field[] getDeclaredFields(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredFields();
        }
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredFields();
            }
        };
        return (Field[])AccessController.doPrivileged(action);
    }

    protected Method[] getDeclaredMethods(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredMethods();
        }
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredMethods();
            }
        };
        return (Method[])AccessController.doPrivileged(action);
    }
}

