/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme;

import java.util.ArrayList;
import java.util.List;
import org.jboss.portal.theme.RuntimeContext;
import org.jboss.portal.theme.ServerRegistrationID;
import org.jboss.portal.theme.ThemeLink;
import org.jboss.portal.theme.ThemeScript;
import org.jboss.portal.theme.metadata.PortalThemeMetaData;
import org.jboss.portal.theme.metadata.ThemeLinkMetaData;
import org.jboss.portal.theme.metadata.ThemeScriptMetaData;

public final class ThemeInfo {
    private final RuntimeContext ctx;
    private final PortalThemeMetaData meta;
    private final ServerRegistrationID registrationId;
    private final List scripts;
    private final List links;
    private final List elements;

    public ThemeInfo(RuntimeContext ctx, PortalThemeMetaData meta) {
        int i;
        this.ctx = ctx;
        this.meta = meta;
        this.registrationId = ServerRegistrationID.createID(ServerRegistrationID.TYPE_THEME, new String[]{ctx.getAppId(), meta.getName()});
        this.scripts = new ArrayList(meta.getScripts());
        this.links = new ArrayList(meta.getLinks());
        for (i = 0; i < this.scripts.size(); ++i) {
            ThemeScriptMetaData scriptMD = (ThemeScriptMetaData)this.scripts.get(i);
            ThemeScript script = new ThemeScript(ctx.getContextPath(), scriptMD.getSrc(), scriptMD.getId(), scriptMD.getType(), scriptMD.getBodyContent(), scriptMD.getCharset());
            this.scripts.set(i, script);
        }
        for (i = 0; i < this.links.size(); ++i) {
            ThemeLinkMetaData linkMD = (ThemeLinkMetaData)this.links.get(i);
            ThemeLink link = new ThemeLink(ctx.getContextPath(), linkMD.getRel(), linkMD.getType(), linkMD.getHref(), linkMD.getId(), linkMD.getTitle(), linkMD.getMedia());
            this.links.set(i, link);
        }
        this.elements = new ArrayList(this.scripts.size() + this.links.size());
        this.elements.addAll(this.scripts);
        this.elements.addAll(this.links);
    }

    public String getContextPath() {
        return this.ctx.getContextPath();
    }

    public String getAppId() {
        return this.ctx.getAppId();
    }

    public String getName() {
        return this.meta.getName();
    }

    public List getScripts() {
        return this.scripts;
    }

    public List getLinks() {
        return this.links;
    }

    public List getElements() {
        return this.elements;
    }

    public String toString() {
        return this.meta.getName();
    }

    public ServerRegistrationID getRegistrationId() {
        return this.registrationId;
    }
}

