/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.policy.util;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ws.policy.AbstractAssertion;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.apache.ws.policy.util.PolicyRegistry;

public class PolicyUtil {
    public static boolean matchByQName(PrimitiveAssertion primTermA, PrimitiveAssertion primTermB) {
        return primTermA.getName().equals(primTermB.getName());
    }

    public static boolean matchByQName(List primTermsA, List primTermsB) {
        List larger = primTermsA.size() > primTermsB.size() ? primTermsA : primTermsB;
        List smaller = primTermsA.size() < primTermsB.size() ? primTermsA : primTermsB;
        Iterator iterator = larger.iterator();
        while (iterator.hasNext()) {
            PrimitiveAssertion primTerm = (PrimitiveAssertion)iterator.next();
            QName qname = primTerm.getName();
            Iterator iterator2 = smaller.iterator();
            boolean match = false;
            while (iterator2.hasNext()) {
                PrimitiveAssertion primTerm2 = (PrimitiveAssertion)iterator2.next();
                if (!primTerm2.getName().equals(qname)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    public static List getPrimTermsList(Policy policy) {
        if (!policy.isNormalized()) {
            policy = (Policy)policy.normalize();
        }
        XorCompositeAssertion xorTerm = (XorCompositeAssertion)policy.getTerms().get(0);
        AndCompositeAssertion andTerm = (AndCompositeAssertion)xorTerm.getTerms().get(0);
        return andTerm.getTerms();
    }

    public static Policy getSinglePolicy(List policyList, PolicyRegistry reg) {
        AbstractAssertion policyTerm = null;
        Iterator iterator = policyList.iterator();
        while (iterator.hasNext()) {
            Policy policyTerm2 = (Policy)iterator.next();
            policyTerm = policyTerm == null ? policyTerm2 : (Policy)((Policy)policyTerm).merge(policyTerm2, reg);
        }
        if (!policyTerm.isNormalized()) {
            policyTerm = (Policy)((Policy)policyTerm).normalize();
        }
        return policyTerm;
    }

    public static Policy getPolicy(List terms) {
        Policy policyTerm = new Policy();
        XorCompositeAssertion xorTerm = new XorCompositeAssertion();
        AndCompositeAssertion andTerm = new AndCompositeAssertion();
        andTerm.addTerms(terms);
        xorTerm.addTerm(andTerm);
        policyTerm.addTerm(xorTerm);
        return policyTerm;
    }
}

