/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.Email;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class EmailHandler
extends AbstractHandler {
    public static final String TAG_NAME = "email";
    private HandlerMaker maker = null;

    protected EmailHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        Email obj = new Email();
        String useType = element.getAttribute("useType");
        if (useType != null && useType.trim().length() > 0) {
            obj.setUseType(useType);
        }
        obj.setValue(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String emailValue;
        Email email = (Email)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        String useType = email.getUseType();
        if (useType != null && useType.trim().length() > 0) {
            element.setAttribute("useType", useType);
        }
        if ((emailValue = email.getValue()) != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(emailValue));
        }
        parent.appendChild(element);
    }
}

