/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.db;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.naming.InitialContext;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.CachedUserImpl;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.ProfileMap;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.db.HibernateUserImpl;
import org.jboss.portal.identity.info.ProfileInfo;
import org.jboss.portal.identity.info.PropertyInfo;
import org.jboss.portal.identity.service.UserProfileModuleService;

public class HibernateUserProfileModuleImpl
extends UserProfileModuleService {
    private static final Logger log = Logger.getLogger(HibernateUserProfileModuleImpl.class);
    protected SessionFactory sessionFactory;
    protected UserModule userModule;
    protected String sessionFactoryJNDIName;
    private boolean synchronizeNonExistingUsers = true;
    private boolean enableSynchronizedUsers = true;
    private boolean acceptOtherImplementations = true;
    private String defaultSynchronizePassword;
    private boolean randomSynchronizePassword = false;

    public void start() throws Exception {
        this.sessionFactory = (SessionFactory)new InitialContext().lookup(this.sessionFactoryJNDIName);
        super.start();
    }

    public void stop() throws Exception {
        this.sessionFactory = null;
        super.stop();
    }

    public String getSessionFactoryJNDIName() {
        return this.sessionFactoryJNDIName;
    }

    public void setSessionFactoryJNDIName(String sessionFactoryJNDIName) {
        this.sessionFactoryJNDIName = sessionFactoryJNDIName;
    }

    public Object getProperty(User user, String propertyName) throws IdentityException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name need to have value");
        }
        HibernateUserImpl dbUser = this.processUser(user);
        PropertyInfo pi = this.getProfileInfo().getPropertyInfo(propertyName);
        if (pi == null) {
            throw new IdentityException("Cannot find profile information about property: " + propertyName);
        }
        return dbUser.getProfileMap().get(propertyName);
    }

    public void setProperty(User user, String propertyName, Object propertyValue) throws IdentityException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name need to have value");
        }
        HibernateUserImpl dbUser = this.processUser(user);
        PropertyInfo pi = this.getProfileInfo().getPropertyInfo(propertyName);
        if (pi == null) {
            throw new IdentityException("Cannot find profile information about property: " + propertyName);
        }
        if (!pi.getAccessMode().equals("read-write")) {
            throw new IdentityException("Property is not allowed for write access: " + propertyName);
        }
        if (propertyValue != null && !pi.getType().equals(propertyValue.getClass().getName())) {
            throw new IdentityException("Wrong property type. Must be: " + pi.getType() + "; and found: " + propertyValue.getClass().getName());
        }
        if (propertyValue != null) {
            dbUser.getProfileMap().put(propertyName, propertyValue);
        } else {
            dbUser.getProfileMap().remove(propertyName);
        }
        this.fireUserProfileChangedEvent(user.getId(), user.getUserName(), propertyName, propertyValue);
    }

    public Map getProperties(User user) throws IdentityException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        HibernateUserImpl dbUser = this.processUser(user);
        HashMap props = new HashMap();
        ProfileMap profile = dbUser.getProfileMap();
        Set keys = profile.keySet();
        for (String key : keys) {
            props.put(key, profile.get(key));
        }
        return Collections.unmodifiableMap(props);
    }

    protected Session getCurrentSession() {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("No session factory");
        }
        return this.sessionFactory.getCurrentSession();
    }

    protected HibernateUserImpl processUser(User user) throws IdentityException {
        if (user instanceof CachedUserImpl) {
            try {
                user = this.getUserModule().findUserById(user.getId());
            }
            catch (NoSuchUserException e) {
                throw new IdentityException("Illegal state - cached user doesn't exist in identity store: ", e);
            }
        }
        if (user instanceof HibernateUserImpl) {
            return (HibernateUserImpl)user;
        }
        if (!this.isAcceptOtherImplementations()) {
            throw new IllegalArgumentException("This UserProfileModule implementation support only HibenrateUserImpl objects - set acceptOtherImplementations option to true");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing non HibernateUserImpl object: " + user.getClass()));
        }
        Session session = this.getCurrentSession();
        Query query = session.createQuery("from HibernateUserImpl where userName=:userName");
        query.setParameter("userName", (Object)user.getUserName());
        query.setCacheable(true);
        HibernateUserImpl hu = (HibernateUserImpl)query.uniqueResult();
        if (hu != null) {
            return hu;
        }
        if (!this.isSynchronizeNonExistingUsers()) {
            throw new IdentityException("No user in DB - set synchronizeNonExistingUsers option to true");
        }
        try {
            hu = new HibernateUserImpl(user.getUserName());
            if (this.defaultSynchronizePassword != null) {
                hu.updatePassword(this.getDefaultSynchronizePassword());
            } else if (this.randomSynchronizePassword) {
                Random r = new Random();
                StringBuffer password = new StringBuffer();
                for (int i = 0; i < 10; ++i) {
                    password.append(r.nextDouble());
                }
                hu.updatePassword(password.toString());
            }
            session = this.getCurrentSession();
            if (this.isEnableSynchronizedUsers()) {
                hu.setEnabled(true);
            }
            session.save((Object)hu);
            return hu;
        }
        catch (HibernateException e) {
            String message = "Cannot create user " + user.getUserName();
            log.error((Object)message, (Throwable)e);
            throw new IdentityException(message, e);
        }
    }

    public ProfileInfo getProfileInfo() throws IdentityException {
        if (this.profileInfo == null) {
            UserProfileModule module = (UserProfileModule)this.getIdentityContext().getObject("UserProfile");
            if (module == this) {
                throw new IdentityException("ProfileInfo not accessible - check configuration");
            }
            this.setProfileInfo(module.getProfileInfo());
        }
        return this.profileInfo;
    }

    public boolean isSynchronizeNonExistingUsers() {
        return this.synchronizeNonExistingUsers;
    }

    public void setSynchronizeNonExistingUsers(boolean synchronizeNonExistingUsers) {
        this.synchronizeNonExistingUsers = synchronizeNonExistingUsers;
    }

    public boolean isEnableSynchronizedUsers() {
        return this.enableSynchronizedUsers;
    }

    public void setEnableSynchronizedUsers(boolean enableSynchronizedUsers) {
        this.enableSynchronizedUsers = enableSynchronizedUsers;
    }

    public boolean isAcceptOtherImplementations() {
        return this.acceptOtherImplementations;
    }

    public void setAcceptOtherImplementations(boolean acceptOtherImplementations) {
        this.acceptOtherImplementations = acceptOtherImplementations;
    }

    public String getDefaultSynchronizePassword() {
        return this.defaultSynchronizePassword;
    }

    public void setDefaultSynchronizePassword(String defaultSynchronizePassword) {
        this.defaultSynchronizePassword = defaultSynchronizePassword;
    }

    public boolean isRandomSynchronizePassword() {
        return this.randomSynchronizePassword;
    }

    public void setRandomSynchronizePassword(boolean randomSynchronizePassword) {
        this.randomSynchronizePassword = randomSynchronizePassword;
    }

    protected UserModule getUserModule() throws IdentityException {
        if (this.userModule == null) {
            try {
                this.userModule = (UserModule)this.getIdentityContext().getObject("User");
            }
            catch (ClassCastException e) {
                throw new IdentityException("Not supported object as part of the context - must be UserModule", e);
            }
        }
        return this.userModule;
    }
}

