/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import javax.xml.namespace.QName;
import org.jboss.portal.api.content.SelectedContent;
import org.jboss.portal.core.CoreConstants;
import org.jboss.portal.core.admin.ui.AuthorizationBean;
import org.jboss.portal.core.admin.ui.ControlPropertiesBean;
import org.jboss.portal.core.admin.ui.InstanceManagerBean;
import org.jboss.portal.core.admin.ui.MultiPortalsAuthorizationBean;
import org.jboss.portal.core.admin.ui.PropertiesBean;
import org.jboss.portal.core.admin.ui.ThemeBean;
import org.jboss.portal.core.admin.ui.actions.AddPageAction;
import org.jboss.portal.core.admin.ui.actions.PropertyAction;
import org.jboss.portal.core.admin.ui.common.PageManagerBean;
import org.jboss.portal.core.admin.ui.portlet.PortletDefinitionInvoker;
import org.jboss.portal.core.controller.coordination.CoordinationConfigurator;
import org.jboss.portal.core.event.PortalEventListenerRegistry;
import org.jboss.portal.core.impl.model.content.ContentProviderRegistryService;
import org.jboss.portal.core.model.content.Content;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.ContentProvider;
import org.jboss.portal.core.model.content.spi.portlet.ContentPortlet;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.portal.Context;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.faces.component.portlet.PortletEventEvent;
import org.jboss.portal.faces.gui.BeanContext;
import org.jboss.portal.faces.gui.JSFBeanContext;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletInvoker;
import org.jboss.portal.portlet.info.NavigationInfo;
import org.jboss.portal.portlet.info.ParameterInfo;
import org.jboss.portal.portlet.invocation.response.UpdateNavigationalStateResponse;
import org.jboss.portal.security.RoleSecurityBinding;
import org.jboss.portal.security.SecurityConstants;
import org.jboss.portal.security.spi.provider.DomainConfigurator;
import org.jboss.portal.theme.LayoutService;
import org.jboss.portal.theme.ThemeService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalObjectManagerBean
implements Serializable,
AddPageAction.Listener {
    private static final long serialVersionUID = -8923517554726982622L;
    private static final QName CONTENT_SELECT = new QName("urn:jboss:portal:content", "select");
    private String namespace = "";
    private PortalObjectContainer portalObjectContainer;
    private CoordinationConfigurator coordinationService;
    private InstanceContainer instanceContainer;
    private LayoutService layoutService;
    private ThemeService themeService;
    private DomainConfigurator domainConfigurator;
    private RoleModule roleModule;
    private PortalEventListenerRegistry listenerRegistry;
    private PortalObjectId selectedId;
    private String selectedPlugin;
    private ContentType selectedContentType = ContentType.PORTLET;
    private String selectedContentURI;
    private Map selectedContentParameters = new HashMap();
    private Map<String, String[]> renderParameters;
    private final AuthorizationBean auth = new PortalObjectAuthorizationBean();
    private SelectItem[] instanceItems;
    private SelectItem[] portalPageItems;
    private List selectedObjectPath;
    private PortalObject selectedObject;
    private PortalObject selectedDeletingObject;
    private PropertiesBean selectedProperties;
    PropertyAction propertyAction;
    private ControlPropertiesBean controlProperties;
    private PortletInvoker portletDefinitionInvoker;
    private ThemeBean theme;
    public PageManagerBean pageManager;
    private Boolean maximizedStateExists;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List getAvailableContentTypes() {
        LinkedList<SelectItem> types = new LinkedList<SelectItem>();
        for (Object o : ContentProviderRegistryService.getInstance().getContentTypes()) {
            ContentType contentType = (ContentType)o;
            SelectItem item = new SelectItem();
            item.setValue((Object)contentType);
            item.setLabel(contentType.toString());
            if (contentType.equals((Object)ContentType.PORTLET)) {
                types.addFirst(item);
                continue;
            }
            types.addLast(item);
        }
        return types;
    }

    public String getSelectedContentEditorInstance() {
        ContentProvider contentProvider;
        if (this.selectedContentType != null && (contentProvider = ContentProviderRegistryService.getInstance().getContentProvider(this.selectedContentType)) != null) {
            return contentProvider.getPortletInfo().getPortletName(ContentPortlet.EDIT_CONTENT_MODE);
        }
        return null;
    }

    public PortalEventListenerRegistry getListenerRegistry() {
        return this.listenerRegistry;
    }

    public void setListenerRegistry(PortalEventListenerRegistry listenerRegistry) {
        this.listenerRegistry = listenerRegistry;
    }

    public RoleModule getRoleModule() {
        return this.roleModule;
    }

    public void setRoleModule(RoleModule roleModule) {
        this.roleModule = roleModule;
    }

    public PortalObjectContainer getPortalObjectContainer() {
        return this.portalObjectContainer;
    }

    public void setPortalObjectContainer(PortalObjectContainer poc) {
        this.portalObjectContainer = poc;
    }

    public CoordinationConfigurator getCoordinationService() {
        return this.coordinationService;
    }

    public void setCoordinationService(CoordinationConfigurator coordinationService) {
        this.coordinationService = coordinationService;
    }

    public InstanceContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public void setInstanceContainer(InstanceContainer instanceContainer) {
        this.instanceContainer = instanceContainer;
        this.portletDefinitionInvoker = new PortletDefinitionInvoker(instanceContainer);
    }

    public LayoutService getLayoutService() {
        return this.layoutService;
    }

    public void setLayoutService(LayoutService layoutService) {
        this.layoutService = layoutService;
    }

    public ThemeService getThemeService() {
        return this.themeService;
    }

    public void setThemeService(ThemeService themeService) {
        this.themeService = themeService;
    }

    public ContentType getSelectedContentType() {
        return this.selectedContentType;
    }

    public void setSelectedContentType(ContentType selectedContentType) {
        this.selectedContentType = selectedContentType;
    }

    public String getSelectedContentURI() {
        return this.selectedContentURI;
    }

    public void setSelectedContentURI(String selectedContentURI) {
        this.selectedContentURI = selectedContentURI;
    }

    public String getSelectedPlugin() {
        return this.selectedPlugin;
    }

    public void setSelectedPlugin(String selectedPlugin) {
        this.selectedPlugin = selectedPlugin;
    }

    public Map getRenderParameters() {
        return this.renderParameters;
    }

    public void setRenderParameters(Map renderParameters) {
        this.renderParameters = renderParameters;
    }

    public Map getSelectedContentParameters() {
        return this.selectedContentParameters;
    }

    public void setSelectedContentParameters(Map selectedContentParameters) {
        this.selectedContentParameters = selectedContentParameters;
    }

    public DomainConfigurator getDomainConfigurator() {
        return this.domainConfigurator;
    }

    public void setDomainConfigurator(DomainConfigurator domainConfigurator) {
        this.domainConfigurator = domainConfigurator;
    }

    public PortletInvoker getPortletDefinitionInvoker() {
        return this.portletDefinitionInvoker;
    }

    public AuthorizationBean getAuth() {
        return this.auth;
    }

    public SelectItem[] getInstanceItems() {
        return this.instanceItems;
    }

    public SelectItem[] getPortalPageItems() {
        return this.portalPageItems;
    }

    public List getSelectedObjectPath() {
        return this.selectedObjectPath;
    }

    public PortalObject getSelectedObject() {
        return this.selectedObject;
    }

    public PortalObject getSelectedDeletingObject() {
        return this.selectedDeletingObject;
    }

    public PropertiesBean getSelectedProperties() {
        return this.selectedProperties;
    }

    public ThemeBean getTheme() {
        return this.theme;
    }

    public Boolean getMaximizedStateExists() {
        return this.maximizedStateExists;
    }

    public void setMaximizedStateExists(Boolean maximizedStateExists) {
        this.maximizedStateExists = maximizedStateExists;
    }

    public void selectObject(PortalObject po) {
        if (po != null) {
            this.selectObject(po.getId());
        } else {
            this.selectObject((PortalObjectId)null);
        }
    }

    public void selectObject(PortalObjectId id) {
        if (id == null) {
            this.selectedId = null;
            this.selectedPlugin = null;
            this.selectedContentType = ContentType.PORTLET;
            this.selectedContentURI = null;
        } else {
            this.selectedId = id;
            this.selectedPlugin = "manager";
            this.selectedContentType = ContentType.PORTLET;
            this.selectedContentURI = null;
        }
    }

    public void selectObject(ActionEvent ae) {
        this.selectObject();
    }

    public void selectDeletingObject(ActionEvent ae) {
        PortalObjectId poid = this.getSelectedPortalObjectId();
        this.selectedDeletingObject = this.portalObjectContainer.getObject(poid);
        this.selectObject();
    }

    public String makeObjectDefault() {
        PortalObjectId poid = this.getSelectedPortalObjectId();
        PortalObject object = this.portalObjectContainer.getObject(poid);
        if (object != null) {
            String typeName;
            int type = object.getType();
            if (type == 1 || type == 0) {
                typeName = "portal";
            } else if (type == 2) {
                typeName = "page";
            } else {
                throw new IllegalArgumentException("Invalid object type to set as default");
            }
            PortalObject parent = object.getParent();
            if (parent != null) {
                String name = object.getName();
                parent.setDeclaredProperty("portal.defaultObjectName", name);
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Success", "'" + name + "' " + typeName + " was successfully set as default " + typeName);
                FacesContext.getCurrentInstance().addMessage("status", message);
            }
        }
        return null;
    }

    public String selectObject() {
        try {
            PortalObjectId poid = this.getSelectedPortalObjectId();
            Map<String, String> pmap = this.getRequestParameterMap();
            this.maximizedStateExists = Boolean.valueOf(pmap.get("maximizedStateExists"));
            PortalObject object = this.portalObjectContainer.getObject(poid);
            if (object != null) {
                this.selectObject(poid);
                this.selectedObject = object;
                switch (object.getType()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        Window window = (Window)object;
                        this.selectedContentType = window.getContentType();
                        Content content = window.getContent();
                        if (content == null) break;
                        this.renderParameters = new HashMap<String, String[]>();
                        Portlet portlet = this.instanceContainer.getDefinition(this.getSelectedContentEditorInstance()).getPortlet();
                        NavigationInfo navigationInfo = portlet.getInfo().getNavigation();
                        ParameterInfo parameterInfo = navigationInfo.getPublicParameter(CoreConstants.JBOSS_PORTAL_CONTENT_URI);
                        if (parameterInfo == null) break;
                        this.renderParameters.put(parameterInfo.getId(), new String[]{content.getURI()});
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "objects";
    }

    public PortalObjectId getSelectedPortalObjectId() {
        Map<String, String> pmap = this.getRequestParameterMap();
        String id = pmap.get("id");
        PortalObjectId portalObjectId = null;
        if (id != null) {
            portalObjectId = PortalObjectId.parse((String)id, (PortalObjectPath.Format)PortalObjectPath.LEGACY_BASE64_FORMAT);
        }
        this.selectObject(portalObjectId);
        return this.selectedId;
    }

    public void selectPlugin() {
        Map<String, String> pmap = this.getRequestParameterMap();
        this.selectedPlugin = pmap.get("plugin");
    }

    public Map<String, String> getRequestParameterMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
    }

    public void selectParentObject(ActionEvent actionEvent) {
        PortalObject parent = this.getSelectedObjectParent();
        this.selectObject(parent);
    }

    public PortalObject getSelectedObjectParent() {
        PortalObject current = this.getSelectedObject();
        PortalObject parent = current.getParent();
        return parent == null ? current : parent;
    }

    public void selectRootObject(ActionEvent ae) {
        Context root = this.portalObjectContainer.getContext(this.namespace);
        this.selectObject((PortalObject)root);
    }

    public void udpateContentType() {
    }

    public void destroyObject(ActionEvent ae) {
        try {
            this.selectObject((PortalObjectId)null);
            String id = (String)ae.getComponent().getAttributes().get("objectId");
            if (id != null) {
                PortalObjectId poid = PortalObjectId.parse((String)id, (PortalObjectPath.Format)PortalObjectPath.LEGACY_BASE64_FORMAT);
                PortalObject object = this.portalObjectContainer.getObject(poid);
                if (object != null) {
                    this.selectObject(object.getParent());
                    String stringMessage = object.getName() + " has successfully been destroyed";
                    object.getParent().destroyChild(object.getName());
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, stringMessage, stringMessage);
                    FacesContext.getCurrentInstance().addMessage("status", message);
                    this.selectedDeletingObject = null;
                } else {
                    String stringMessage = "Cannot delete this already deleted object";
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, stringMessage, stringMessage);
                    FacesContext.getCurrentInstance().addMessage("status", message);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refresh() {
        this.propertyAction = null;
        this.instanceItems = null;
        this.portalPageItems = null;
        this.selectedObjectPath = null;
        this.selectedObject = null;
        this.selectedProperties = null;
        this.controlProperties = null;
        this.theme = null;
        if (this.selectedId == null) {
            this.selectedId = new PortalObjectId(this.namespace, PortalObjectPath.ROOT_PATH);
        }
        this.selectedObject = this.portalObjectContainer.getObject(this.selectedId);
        if (this.selectedObject.getType() == 2) {
            if (this.pageManager == null) {
                this.pageManager = new PageManagerBean(this.layoutService, this.portletDefinitionInvoker);
                this.pageManager.setBeanContext((BeanContext)new JSFBeanContext());
            }
            this.pageManager.page = (Page)this.selectedObject;
        }
        this.selectedProperties = new PropertiesBean(this);
        this.controlProperties = new ControlPropertiesBean(this);
        this.propertyAction = new PropertyAction(this);
        this.propertyAction.setBeanContext((BeanContext)new JSFBeanContext());
        this.theme = new ThemeBean(this.selectedObject);
        Collection pages = this.getSelectedObject().getChildren(4);
        ArrayList<SelectItem> list = new ArrayList<SelectItem>(pages.size() + 1);
        for (PortalObject page : pages) {
            SelectItem item = new SelectItem((Object)page.getName());
            list.add(item);
        }
        list.add(new SelectItem((Object)"", "no selection"));
        this.portalPageItems = list.toArray(new SelectItem[list.size()]);
        ArrayList<PortalObject> path = new ArrayList<PortalObject>();
        for (PortalObject o = this.getSelectedObject(); o != null; o = o.getParent()) {
            path.add(o);
        }
        Collections.reverse(path);
        this.selectedObjectPath = path;
        ArrayList<SelectItem> tmp = new ArrayList<SelectItem>(this.instanceContainer.getDefinitions());
        Collections.sort(tmp, InstanceManagerBean.INSTANCE_COMPARATOR);
        for (int i = 0; i < tmp.size(); ++i) {
            Instance instance = (Instance)tmp.get(i);
            SelectItem item = new SelectItem((Object)instance.getId());
            tmp.set(i, item);
        }
        this.instanceItems = tmp.toArray(new SelectItem[tmp.size()]);
    }

    public void processEvent(ActionEvent event) {
        PortletEventEvent eventEvent;
        UpdateNavigationalStateResponse.Event portletEvent;
        QName name;
        if (event instanceof PortletEventEvent && CONTENT_SELECT.equals(name = (portletEvent = (eventEvent = (PortletEventEvent)event).getEvent()).getName())) {
            if (portletEvent.getPayload() instanceof String) {
                String uri = (String)((Object)portletEvent.getPayload());
                PortalObject po = this.getSelectedObject();
                switch (po.getType()) {
                    case 3: {
                        Window window = (Window)po;
                        window.getContent().setURI(uri);
                        this.selectParentObject(event);
                        break;
                    }
                }
            } else if (portletEvent.getPayload() instanceof SelectedContent) {
                SelectedContent selectedContent = (SelectedContent)portletEvent.getPayload();
                String uri = selectedContent.getUri();
                Map parameters = selectedContent.getParameters();
                PortalObject po = this.getSelectedObject();
                switch (po.getType()) {
                    case 3: {
                        Window window = (Window)po;
                        window.getContent().setURI(uri);
                        window.getContent().setParameters(parameters);
                        this.selectParentObject(event);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void pageCreated(Page page) {
        Set<RoleSecurityBinding> constraints = Collections.singleton(new RoleSecurityBinding("viewrecursive", SecurityConstants.UNCHECKED_ROLE_NAME));
        this.getDomainConfigurator().setSecurityBindings(page.getId().toString(PortalObjectPath.CANONICAL_FORMAT), constraints);
    }

    public String getPreviewURL() {
        return "http://www.jboss.org";
    }

    public String getSelectedObjectType() {
        PortalObject object = this.getSelectedObject();
        return object != null ? this.getReadableObjectTypeFor(object.getType()) : "unknown";
    }

    public String getReadableObjectTypeFor(int portalObjectType) {
        switch (portalObjectType) {
            case 0: {
                return "context";
            }
            case 1: {
                return "portal";
            }
            case 2: {
                return "page";
            }
            case 3: {
                return "window";
            }
        }
        return "unknown";
    }

    public ControlPropertiesBean getControlProperties() {
        return this.controlProperties;
    }

    public SelectItem[] getListenerIds() {
        Set ids = this.listenerRegistry.getListenerIds();
        if (ids != null) {
            SelectItem[] result = new SelectItem[ids.size() + 1];
            int i = 1;
            ResourceBundle rb = ResourceBundle.getBundle("Resource", FacesContext.getCurrentInstance().getExternalContext().getRequestLocale());
            result[0] = new SelectItem((Object)"", rb.getString("NO_BOUND_LISTENER"));
            for (Object id : ids) {
                result[i++] = new SelectItem(id);
            }
            return result;
        }
        return null;
    }

    public class PortalObjectAuthorizationBean
    extends MultiPortalsAuthorizationBean {
        public String getManagedPortalName() {
            int endPortal;
            String portalName = null;
            String uri = this.getURI();
            if (uri != null && uri.length() > 0 && (endPortal = (portalName = uri.substring(1)).indexOf("/")) != -1) {
                portalName = portalName.substring(0, endPortal);
            }
            return portalName;
        }

        public DomainConfigurator getDomainConfigurator() {
            return PortalObjectManagerBean.this.getDomainConfigurator();
        }

        protected String getURI() {
            PortalObject po = PortalObjectManagerBean.this.getSelectedObject();
            if (po != null) {
                return po.getId().toString(PortalObjectPath.CANONICAL_FORMAT);
            }
            return null;
        }

        public SelectItem[] getAvailableActions() {
            return new SelectItem[]{new SelectItem((Object)"view", "View"), new SelectItem((Object)"viewrecursive", "View Recursive"), new SelectItem((Object)"personalize", "Personalize"), new SelectItem((Object)"personalizerecursive", "Personalize Recursive")};
        }

        public String submit() {
            String stringMessage = "Security has been correctly updated on the page";
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, stringMessage, stringMessage);
            FacesContext.getCurrentInstance().addMessage("status", message);
            return "objects";
        }

        public String cancel() {
            return "objects";
        }

        public RoleModule getRoleModule() {
            return PortalObjectManagerBean.this.roleModule;
        }
    }
}

