/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.util.CollectionsFactory;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class AbstractDependencyInfo
extends JBossObject
implements DependencyInfo {
    private Set iDependOn = CollectionsFactory.createCopyOnWriteSet();
    private Set dependsOnMe = CollectionsFactory.createCopyOnWriteSet();
    private Set unresolved = CollectionsFactory.createCopyOnWriteSet();

    public Set getIDependOn(Class type) {
        if (type == null || this.iDependOn.isEmpty()) {
            return this.iDependOn;
        }
        HashSet<DependencyItem> set = new HashSet<DependencyItem>();
        Iterator i = this.iDependOn.iterator();
        while (i.hasNext()) {
            DependencyItem item = (DependencyItem)i.next();
            if (!type.isInstance(item)) continue;
            set.add(item);
        }
        return set;
    }

    public void addIDependOn(DependencyItem dependency) {
        this.iDependOn.add(dependency);
        this.unresolved.add(dependency);
        this.flushJBossObjectCache();
    }

    public void removeIDependOn(DependencyItem dependency) {
        this.iDependOn.remove(dependency);
        this.unresolved.remove(dependency);
        this.flushJBossObjectCache();
    }

    public Set getDependsOnMe(Class type) {
        if (type == null || this.dependsOnMe.isEmpty()) {
            return this.dependsOnMe;
        }
        HashSet<DependencyItem> set = new HashSet<DependencyItem>();
        Iterator i = this.dependsOnMe.iterator();
        while (i.hasNext()) {
            DependencyItem item = (DependencyItem)i.next();
            if (!type.isInstance(item)) continue;
            set.add(item);
        }
        return set;
    }

    public void addDependsOnMe(DependencyItem dependency) {
        this.dependsOnMe.add(dependency);
        this.flushJBossObjectCache();
    }

    public void removeDependsOnMe(DependencyItem dependency) {
        this.dependsOnMe.add(dependency);
        this.flushJBossObjectCache();
    }

    public boolean resolveDependencies(Controller controller, ControllerState state) {
        boolean resolved = true;
        if (!this.unresolved.isEmpty()) {
            Iterator i = this.unresolved.iterator();
            while (i.hasNext()) {
                DependencyItem item = (DependencyItem)i.next();
                if (!state.equals((Object)item.getWhenRequired()) || item.resolve(controller)) continue;
                resolved = false;
                break;
            }
        }
        return resolved;
    }

    public Set getUnresolvedDependencies() {
        return this.unresolved;
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("idependOn=").append((Object)this.iDependOn);
        if (!this.unresolved.isEmpty()) {
            buffer.append(" unresolved=").append((Object)this.unresolved);
        }
    }
}

