/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.deployment.jboss;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import org.jboss.deployment.DeploymentException;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.portlet.PortletInvoker;
import org.jboss.portal.portlet.container.ContainerPortletInvoker;
import org.jboss.portal.portlet.container.PortletContainer;
import org.jboss.portal.portlet.container.managed.LifeCycleStatus;
import org.jboss.portal.portlet.container.managed.ManagedObject;
import org.jboss.portal.portlet.container.managed.ManagedObjectEvent;
import org.jboss.portal.portlet.container.managed.ManagedObjectLifeCycleEvent;
import org.jboss.portal.portlet.container.managed.ManagedObjectRegistryEvent;
import org.jboss.portal.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.jboss.portal.portlet.deployment.jboss.InfoBuilderFactory;
import org.jboss.portal.portlet.deployment.jboss.JBossApplicationMetaDataFactory;
import org.jboss.portal.portlet.deployment.jboss.PortletAppDeployment;
import org.jboss.portal.portlet.deployment.jboss.ValueTrimmingFilter;
import org.jboss.portal.portlet.deployment.jboss.metadata.JBossApplicationMetaData;
import org.jboss.portal.portlet.impl.container.PortletContainerLifeCycle;
import org.jboss.portal.portlet.security.PortletSecurityService;
import org.jboss.portal.server.config.ServerConfig;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.jboss.AbstractDeploymentFactory;
import org.jboss.portal.server.deployment.jboss.Deployment;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.xml.sax.EntityResolver;

public class PortletAppDeploymentFactory
extends AbstractDeploymentFactory {
    protected static final Pattern urlPattern = Pattern.compile(".*/portlet\\.xml");
    protected ServerConfig config;
    protected PortletSecurityService portletSecurityService;
    protected String standardJBossApplicationMetaDataLocation;
    protected JBossApplicationMetaData standardJBossApplicationMetaData;
    protected EntityResolver jbossPortletEntityResolver;
    private PortletInvoker portletContainerInvoker;
    private InfoBuilderFactory coreInfoBuilderFactory;
    protected final ManagedObjectRegistryEventListener bridgeToInvoker = new ManagedObjectRegistryEventListener(){

        public void onEvent(ManagedObjectRegistryEvent event) {
            ManagedObjectEvent managedObjectEvent;
            ManagedObject managedObject;
            if (event instanceof ManagedObjectEvent && (managedObject = (managedObjectEvent = (ManagedObjectEvent)event).getManagedObject()) instanceof PortletContainerLifeCycle) {
                PortletContainerLifeCycle portletContainerLifeCycle = (PortletContainerLifeCycle)managedObject;
                PortletContainer portletContainer = portletContainerLifeCycle.getPortletContainer();
                if (managedObjectEvent instanceof ManagedObjectLifeCycleEvent) {
                    ManagedObjectLifeCycleEvent lifeCycleEvent = (ManagedObjectLifeCycleEvent)managedObjectEvent;
                    LifeCycleStatus status = lifeCycleEvent.getStatus();
                    if (status == LifeCycleStatus.STARTED) {
                        ((ContainerPortletInvoker)PortletAppDeploymentFactory.this.portletContainerInvoker).addPortletContainer(portletContainer);
                    } else {
                        ((ContainerPortletInvoker)PortletAppDeploymentFactory.this.portletContainerInvoker).removePortletContainer(portletContainer);
                    }
                }
            }
        }
    };

    public EntityResolver getJBossPortletEntityResolver() {
        return this.jbossPortletEntityResolver;
    }

    public void setJBossPortletEntityResolver(EntityResolver jbossPortletEntityResolver) {
        this.jbossPortletEntityResolver = jbossPortletEntityResolver;
    }

    public void setCoreInfoBuilderFactory(InfoBuilderFactory coreInfoBuilderFactory) {
        this.coreInfoBuilderFactory = coreInfoBuilderFactory;
    }

    public InfoBuilderFactory getCoreInfoBuilderFactory() {
        return this.coreInfoBuilderFactory;
    }

    public ServerConfig getConfig() {
        return this.config;
    }

    public void setConfig(ServerConfig config) {
        this.config = config;
    }

    public String getStandardJBossApplicationMetaDataLocation() {
        return this.standardJBossApplicationMetaDataLocation;
    }

    public void setStandardJBossApplicationMetaDataLocation(String standardJBossApplicationMetaDataLocation) {
        this.standardJBossApplicationMetaDataLocation = standardJBossApplicationMetaDataLocation;
    }

    public JBossApplicationMetaData getStandardJBossApplicationMetaData() {
        return this.standardJBossApplicationMetaData;
    }

    public boolean acceptFile(URL url) {
        String urlAsFile = url.getFile();
        Matcher matcher = urlPattern.matcher(urlAsFile);
        return matcher.matches();
    }

    public Deployment newInstance(URL url, PortalWebApp pwa, MBeanServer mbeanServer) throws DeploymentException {
        return new PortletAppDeployment(url, pwa, this.bridgeToInvoker, mbeanServer, this);
    }

    public void start() throws Exception {
        this.loadStandardJBossApplicationMetaData();
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStandardJBossApplicationMetaData() {
        if (this.standardJBossApplicationMetaDataLocation != null) {
            BufferedInputStream in;
            block5: {
                in = null;
                try {
                    in = IOTools.safeBufferedWrapper((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(this.standardJBossApplicationMetaDataLocation));
                    if (in == null) break block5;
                    JBossApplicationMetaDataFactory factory = this.createJBossApplicationMetaDataFactory();
                    Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                    this.standardJBossApplicationMetaData = (JBossApplicationMetaData)unmarshaller.unmarshal((InputStream)in, (ObjectModelFactory)new ValueTrimmingFilter(factory), null);
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        IOTools.safeClose(in);
                        throw throwable;
                    }
                    IOTools.safeClose((Closeable)in);
                }
            }
            IOTools.safeClose((Closeable)in);
        }
    }

    public void stop() {
        super.stop();
    }

    public PortletSecurityService getPortletSecurityService() {
        return this.portletSecurityService;
    }

    public void setPortletSecurityService(PortletSecurityService portletSecurityService) {
        this.portletSecurityService = portletSecurityService;
    }

    public JBossApplicationMetaDataFactory createJBossApplicationMetaDataFactory() {
        return new JBossApplicationMetaDataFactory();
    }

    public PortletInvoker getPortletContainerInvoker() {
        return this.portletContainerInvoker;
    }

    public void setPortletContainerInvoker(PortletInvoker portletContainerInvoker) {
        this.portletContainerInvoker = portletContainerInvoker;
    }
}

