/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.io.Serializable;
import javax.portlet.PortletMode;
import javax.portlet.faces.BridgeException;

public class StateId
implements Serializable {
    private final String scopeId;
    private PortletMode mode;
    private final String uuid;

    public StateId(String scopeId, PortletMode mode, String uuid) {
        this.scopeId = scopeId;
        this.mode = mode;
        this.uuid = uuid;
    }

    public StateId(String stateId) {
        int modeEnd;
        int modeStart = stateId.indexOf(58);
        if (modeStart >= 0) {
            modeEnd = stateId.indexOf(58, modeStart + 1);
            if (modeEnd <= modeStart) {
                throw new BridgeException("Invalid StateId format");
            }
        } else {
            throw new BridgeException("Invalid StateId format");
        }
        this.scopeId = stateId.substring(0, modeStart);
        this.mode = new PortletMode(stateId.substring(modeStart + 1, modeEnd));
        this.uuid = stateId.substring(modeEnd + 1);
    }

    public PortletMode getMode() {
        return this.mode;
    }

    public void setMode(PortletMode mode) {
        this.mode = mode;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String toString() {
        return this.scopeId + ':' + this.mode.toString() + ':' + this.uuid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + (this.scopeId == null ? 0 : this.scopeId.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateId other = (StateId)obj;
        if (this.mode == null ? other.mode != null : !this.mode.equals((Object)other.mode)) {
            return false;
        }
        if (this.scopeId == null ? other.scopeId != null : !this.scopeId.equals(other.scopeId)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

