/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.portlet.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentPortletStateEntry
implements Serializable {
    private Long key;
    private String name;
    private boolean readOnly;
    private int type;
    private String[] strings;
    private List<String> value;
    private boolean dirty;

    public PersistentPortletStateEntry() {
        this.key = null;
        this.name = null;
        this.readOnly = false;
        this.type = 0;
        this.strings = null;
        this.value = null;
        this.dirty = false;
    }

    public PersistentPortletStateEntry(String name, List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.key = null;
        this.name = name;
        this.readOnly = false;
        this.type = 1;
        this.strings = value.toArray(new String[value.size()]);
        this.value = value;
        this.dirty = false;
    }

    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.dirty = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String[] getStrings() {
        return this.strings;
    }

    public void setStrings(String[] strings) {
        this.strings = strings;
        this.dirty = true;
    }

    public List<String> getValue() {
        if (this.dirty) {
            this.value = new ArrayList<String>();
            for (int i = 0; i < this.strings.length; ++i) {
                this.value.add(this.strings[i]);
            }
            this.dirty = false;
        }
        return this.value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[").append(this.name).append(",");
        if (this.strings == null) {
            buffer.append("null,");
        } else {
            buffer.append("(");
            for (int i = 0; i < this.strings.length; ++i) {
                String s = this.strings[i];
                buffer.append(i > 0 ? "," : "").append(s);
            }
            buffer.append("),");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

