/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.dashboard;

import java.util.Collection;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.jboss.portal.common.util.IteratorStatus;
import org.jboss.portal.core.admin.ui.actions.AddPageAction;
import org.jboss.portal.core.admin.ui.common.PageManagerBean;
import org.jboss.portal.core.admin.ui.portlet.PortletDefinitionInvoker;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.portal.NoSuchPortalObjectException;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.faces.gui.BeanContext;
import org.jboss.portal.faces.gui.JSFBeanContext;
import org.jboss.portal.theme.LayoutService;
import org.jboss.portal.theme.ThemeService;

public class DashboardBean
implements AddPageAction.Listener {
    private static final PortalObjectId dashboardId = PortalObjectId.parse((String)"dashboard:/", (PortalObjectPath.Format)PortalObjectPath.CANONICAL_FORMAT);
    public PortalObjectContainer portalObjectContainer;
    public LayoutService layoutService;
    public ThemeService themeService;
    public InstanceContainer instanceContainer;
    public String selectedPageName;
    public Portal userPortal;
    public String selectedPageTheme;
    public String selectedPageLayout;
    public PageManagerBean pageManager;
    public SelectItem[] pageItems;
    public boolean selectePageIsDefault;

    public void pageCreated(Page page) {
        this.selectedPageName = page.getName();
    }

    public void actionRefresh() {
        this.refresh();
    }

    public Page getSelectedPage() {
        return this.pageManager.page;
    }

    private void refresh() {
        String defaultPageName;
        if (this.pageManager == null) {
            this.pageManager = new PageManagerBean(this.layoutService, new PortletDefinitionInvoker(this.instanceContainer));
            this.pageManager.setBeanContext((BeanContext)new JSFBeanContext());
        }
        String userId = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        this.userPortal = (Portal)this.portalObjectContainer.getObject(dashboardId).getChild(userId);
        if (this.userPortal == null) {
            return;
        }
        if (this.selectedPageName != null) {
            this.pageManager.page = this.userPortal.getPage(this.selectedPageName);
        }
        if (this.pageManager.page == null) {
            this.pageManager.page = this.userPortal.getDefaultPage();
            this.selectedPageName = this.pageManager.page.getName();
        }
        if ((defaultPageName = this.pageManager.page.getProperty("portal.defaultObjectName")) == null) {
            defaultPageName = "default";
        }
        this.selectePageIsDefault = this.selectedPageName.equals(defaultPageName);
        Collection pages = this.userPortal.getChildren(4);
        this.pageItems = new SelectItem[pages.size()];
        IteratorStatus i = new IteratorStatus(pages);
        while (i.hasNext()) {
            PortalObject object = (PortalObject)i.next();
            SelectItem item = new SelectItem();
            item.setValue((Object)object.getName());
            item.setLabel(object.getName());
            this.pageItems[i.getIndex()] = item;
        }
    }

    public void renderRefresh() {
        this.refresh();
        if (this.userPortal != null) {
            this.selectedPageTheme = this.userPortal.getDeclaredProperty("theme.id");
            if (this.selectedPageTheme == null) {
                this.selectedPageTheme = "";
            }
            this.selectedPageLayout = this.userPortal.getDeclaredProperty("layout.id");
            if (this.selectedPageLayout == null) {
                this.selectedPageLayout = "";
            }
        }
    }

    public void updateTheme() {
        this.userPortal.setDeclaredProperty("theme.id", "".equals(this.selectedPageTheme) ? null : this.selectedPageTheme);
    }

    public String updateLayout() {
        this.userPortal.setDeclaredProperty("layout.id", "".equals(this.selectedPageLayout) ? null : this.selectedPageLayout);
        return "dashboard";
    }

    public void destroyPage() {
        try {
            this.userPortal.destroyChild(this.selectedPageName);
            String defaultPageName = this.pageManager.page.getProperty("portal.defaultObjectName");
            if (defaultPageName == null) {
                defaultPageName = "default";
            }
            this.selectedPageName = defaultPageName;
        }
        catch (NoSuchPortalObjectException e) {
            e.printStackTrace();
        }
    }

    public PortalObjectContainer getPortalObjectContainer() {
        return this.portalObjectContainer;
    }

    public void setPortalObjectContainer(PortalObjectContainer portalObjectContainer) {
        this.portalObjectContainer = portalObjectContainer;
    }

    public LayoutService getLayoutService() {
        return this.layoutService;
    }

    public void setLayoutService(LayoutService layoutService) {
        this.layoutService = layoutService;
    }

    public ThemeService getThemeService() {
        return this.themeService;
    }

    public void setThemeService(ThemeService themeService) {
        this.themeService = themeService;
    }

    public InstanceContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public void setInstanceContainer(InstanceContainer instanceContainer) {
        this.instanceContainer = instanceContainer;
    }
}

