/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.security;

import java.security.Permission;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.PortalPermissionCollection;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.spi.provider.PermissionRepository;

public final class PortletPermission
extends PortalPermission {
    private static final long serialVersionUID = 8445291296726152562L;
    public static final String VIEW_ACTION = "view";
    public static final int VIEW_MASK = 1;
    private int mask;
    private String actions;
    public static final String PERMISSION_TYPE = "portlet";
    private static final String[] ACTION_NAMES = new String[]{"view"};

    public PortletPermission(PortalPermissionCollection collection) {
        super("portletpermission", collection);
    }

    public PortletPermission(String uri, int mask) {
        super("portletpermission", uri);
        this.mask = mask;
    }

    public PortletPermission(String uri, Collection actions) {
        super("portletpermission", uri);
        if (actions == null) {
            throw new IllegalArgumentException("Actions agurment cannot be null");
        }
        for (String action : actions) {
            this.addAction(action);
        }
    }

    public PortletPermission(String uri, String actions) {
        super("portletpermission", uri);
        if (actions == null) {
            throw new IllegalArgumentException("Actions agurment cannot be null");
        }
        StringTokenizer tokenizer = new StringTokenizer(actions, ",");
        while (tokenizer.hasMoreTokens()) {
            String action = tokenizer.nextToken();
            this.addAction(action);
        }
    }

    private void addAction(String action) throws IllegalArgumentException {
        if (VIEW_ACTION.equals(action)) {
            this.mask |= 1;
        } else {
            throw new IllegalArgumentException("Illegal action " + action);
        }
    }

    public boolean implies(PermissionRepository repository, Subject caller, String roleName, PortalPermission permission) throws PortalSecurityException {
        if (permission instanceof PortletPermission) {
            PortletPermission pp = (PortletPermission)permission;
            if (pp.isContainer()) {
                return false;
            }
            String uri = pp.getURI();
            PortalPermission loaded = repository.getPermission(roleName, uri);
            if (loaded != null && loaded.implies((Permission)((Object)pp))) {
                return true;
            }
        }
        return false;
    }

    public boolean implies(Permission permission) {
        PortletPermission that;
        if (permission instanceof PortletPermission && !this.isContainer() && !(that = (PortletPermission)((Object)permission)).isContainer() && that.uri.equals(this.uri)) {
            return (this.mask & that.mask) == that.mask;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PortletPermission) {
            PortletPermission that = (PortletPermission)((Object)obj);
            if (this.isContainer()) {
                return that.isContainer();
            }
            return this.mask == that.mask && this.uri.equals(that.uri);
        }
        return false;
    }

    public int hashCode() {
        if (this.isContainer()) {
            return 0;
        }
        return this.uri.hashCode() * 43 + this.mask;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer tmp = new StringBuffer();
            for (int i = 0; i < ACTION_NAMES.length; ++i) {
                int mask = 2 >> i;
                if ((this.mask & mask) != mask) continue;
                tmp.append(ACTION_NAMES[i]).append(',');
            }
            int length = tmp.length();
            if (length > 0) {
                tmp.setLength(length - 1);
            }
            this.actions = tmp.toString();
        }
        return this.actions;
    }

    public String getType() {
        return PERMISSION_TYPE;
    }
}

