/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.session;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletSessionUtil;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.logging.Logger;
import org.jboss.portal.portlet.session.AttributeModification;
import org.jboss.portal.portlet.session.SessionModification;

public class SessionListener
implements HttpSessionAttributeListener,
HttpSessionListener {
    private Logger log = Logger.getLogger(SessionListener.class);
    private boolean trace = this.log.isTraceEnabled();
    private static ThreadLocal local = new ThreadLocal();

    public void attributeAdded(HttpSessionBindingEvent event) {
        String name;
        List modifications = (List)local.get();
        if (modifications != null && PortletSessionUtil.decodeScope((String)(name = event.getName())) == 2) {
            if (this.trace) {
                String id = event.getSession().getId();
                this.log.trace((Object)("Adding attribute " + name + " to session " + id));
            }
            Object value = event.getValue();
            AttributeModification mod = new AttributeModification(name, value);
            modifications.add(mod);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        String name;
        List modifications = (List)local.get();
        if (modifications != null && PortletSessionUtil.decodeScope((String)(name = event.getName())) == 2) {
            if (this.trace) {
                String id = event.getSession().getId();
                this.log.trace((Object)("Removing attribute " + name + " to session " + id));
            }
            AttributeModification mod = new AttributeModification(name, null);
            modifications.add(mod);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        String name;
        List modifications = (List)local.get();
        if (modifications != null && PortletSessionUtil.decodeScope((String)(name = event.getName())) == 2) {
            if (this.trace) {
                String id = event.getSession().getId();
                this.log.trace((Object)("Replacing attribute " + name + " to session " + id));
            }
            Object value = event.getSession().getAttribute(name);
            AttributeModification mod = new AttributeModification(name, value);
            modifications.add(mod);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        List modifications = (List)local.get();
        if (modifications != null) {
            if (this.trace) {
                String id = event.getSession().getId();
                this.log.trace((Object)("Creating session " + id));
            }
            modifications.add(SessionModification.SESSION_CREATED);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        List modifications = (List)local.get();
        if (modifications != null) {
            if (this.trace) {
                String id = event.getSession().getId();
                this.log.trace((Object)("Destroying session " + id));
            }
            modifications.add(SessionModification.SESSION_DESTROYED);
        }
    }

    public static void activate() throws IllegalStateException {
        if (local.get() != null) {
            throw new IllegalStateException("Already active");
        }
        local.set(new ArrayList());
    }

    public static List desactivate() throws IllegalStateException {
        List modifications = (List)local.get();
        if (modifications == null) {
            throw new IllegalStateException("No active");
        }
        local.set(null);
        return modifications;
    }
}

