/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.session;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.invocation.MarshalledValue;
import org.jboss.logging.Logger;
import org.jboss.portal.portlet.session.AttributeModification;
import org.jboss.portal.portlet.session.Modification;
import org.jboss.portal.portlet.session.SessionModification;

public class SubSession
implements Externalizable {
    private static final long serialVersionUID = -3584568048652090636L;
    private static final Logger log = Logger.getLogger(SubSession.class);
    private boolean trace = log.isTraceEnabled();
    private boolean activated;
    private Map map;
    private String id;

    public SubSession(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.activated = false;
    }

    public SubSession() {
    }

    public String getId() {
        return this.id;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public Set getAttributeNames() {
        if (this.map != null) {
            return this.map.keySet();
        }
        return Collections.EMPTY_SET;
    }

    public Object getAttribute(String name) {
        this.trace("getAttribute: trying to get attribute named: '" + name + "'");
        if (this.map != null) {
            return this.map.get(name);
        }
        this.trace("getAttribute: no existing attributes.");
        return null;
    }

    public void setAttribute(String name, Object value) {
        if (this.map == null) {
            this.map = new HashMap();
            this.trace("setAttribute: no existing attributes, creating attribute map.");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Must pass a valid, non-null attribute to set the attribute value.");
        }
        if (value == null) {
            this.trace("setAttribute: removing attribute named: '" + name + "'");
            this.map.remove(name);
        } else {
            this.trace("setAttribute: set attribute named: '" + name + "' to value: '" + value + "'");
            this.map.put(name, value);
        }
    }

    public void create() {
        this.trace("create");
        if (this.map != null) {
            this.trace("create: was expecting no map, had to clear it");
            this.map.clear();
        } else {
            this.trace("create: attribute map created");
            this.map = new HashMap();
        }
    }

    public void destroy() {
        this.trace("destroy");
        if (this.map == null) {
            this.trace("destroy: was expecting an attribute map");
        } else {
            this.trace("destroy: attribute map destroyed");
            this.map = null;
        }
    }

    public void synchronizeWithPortalSession(HttpServletRequest portalRequest, List modifications, String key) {
        for (Modification mod : modifications) {
            if (mod instanceof AttributeModification) {
                try {
                    AttributeModification attrMod = (AttributeModification)mod;
                    this.setAttribute(attrMod.getName(), new MarshalledValue(attrMod.getValue()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (mod == SessionModification.SESSION_CREATED) {
                this.create();
                continue;
            }
            this.destroy();
        }
        if (!modifications.isEmpty()) {
            HttpSession session = portalRequest.getSession();
            session.setAttribute(key, (Object)this);
        }
    }

    public void synchronizeWithDispatchedSession(HttpServletRequest dispatchedRequest) {
        if (this.activated) {
            String name;
            this.trace("synchronizeWithDispatchedSession: session was activated, synchronizing...");
            this.activated = false;
            HttpSession session = dispatchedRequest.getSession();
            this.trace("synchronizeWithDispatchedSession: removing existing attributes");
            ArrayList<String> names = new ArrayList<String>();
            Enumeration e = session.getAttributeNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                names.add(name);
            }
            for (int i = 0; i < names.size(); ++i) {
                name = (String)names.get(i);
                this.trace("synchronizeWithDispatchedSession: removing attribute named: '" + name + "' with value: '" + session.getAttribute(name) + "' from existing session");
                session.removeAttribute(name);
            }
            for (Map.Entry entry : this.map.entrySet()) {
                String name2 = (String)entry.getKey();
                try {
                    MarshalledValue marshalledValue = (MarshalledValue)entry.getValue();
                    Object value = marshalledValue.get();
                    session.setAttribute(name2, value);
                    this.trace("synchronizeWithDispatchedSession: setting attribute name: '" + name2 + "' to value: '" + value + "'");
                }
                catch (Exception e2) {
                    log.error((Object)("synchronizeWithDispatchedSession: couldn't unmarshall value for attribute named: '" + name2 + "'. Session won't be properly replicated!"), (Throwable)e2);
                }
            }
        } else {
            this.trace("synchronizeWithDispatchedSession: session was not activated, did nothing");
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.map = (Map)in.readObject();
        this.activated = true;
        if (this.trace) {
            this.log("SubSession deserialized");
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeObject(this.map);
        if (this.trace) {
            this.log("SubSession serialized");
        }
    }

    private void log(String prefix) {
        StringBuffer tmp = new StringBuffer(prefix).append(" [");
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            tmp.append(key).append("(").append(this.map.get(key)).append(")").append(i.hasNext() ? "," : "");
        }
        tmp.append("]");
        this.trace(tmp.toString());
    }

    private void trace(String message) {
        if (this.trace) {
            log.trace((Object)message);
        }
    }
}

