/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.jboss.logging.Logger;
import org.jboss.portal.Mode;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.core.admin.ui.AdminPropertyResolver;
import org.jboss.portal.core.admin.ui.PreferencesBean;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletContext;
import org.jboss.portal.portlet.PortletInvoker;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.federation.FederatedPortletInvoker;
import org.jboss.portal.portlet.federation.FederatingPortletInvoker;
import org.jboss.portal.portlet.federation.impl.FederatedPortlet;
import org.jboss.portal.portlet.info.ModeInfo;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.portlet.info.PreferenceInfo;
import org.jboss.portal.portlet.info.PreferencesInfo;
import org.jboss.portal.security.AuthorizationDomainRegistry;
import org.jboss.portal.security.spi.provider.DomainConfigurator;

public class PortletManagerBean {
    private static final Logger log = Logger.getLogger(PortletManagerBean.class);
    private final Mode INTERNAL_EDIT_CONTENT = Mode.create((String)"edit_content");
    private InstanceContainer instanceContainer;
    private AuthorizationDomainRegistry authorizationDomainRegistry;
    private RoleModule roleModule;
    private FederatingPortletInvoker federatingPortletInvoker;
    private int selectedFrom;
    private int paginationSize;
    private String selectedPortletId;
    private String selectedPlugin;
    private String selectedPortletInvokerId;
    private PreferencesBean selectedPreferences;
    private Portlet selectedPortlet;
    private Collection portletInvokerItems;
    private List portlets;
    private FederatedPortletInvoker selectedPortletInvoker;
    final Comparator comparator = new Comparator(){
        FacesContext ctx = FacesContext.getCurrentInstance();
        Locale locale = this.ctx.getExternalContext().getRequestLocale();

        public int compare(Object o1, Object o2) {
            String p2Name;
            String p1Name;
            Portlet p1 = (Portlet)o1;
            Portlet p2 = (Portlet)o2;
            LocalizedString displayName1 = p1.getInfo().getMeta().getMetaValue("display-name");
            LocalizedString displayName2 = p2.getInfo().getMeta().getMetaValue("display-name");
            if (displayName1 != null && displayName2 != null) {
                p1Name = displayName1.getString(this.locale, true);
                p2Name = displayName2.getString(this.locale, true);
                if (p1Name == null || p2Name == null) {
                    p1Name = p1.getContext().getId();
                    p2Name = p2.getContext().getId();
                }
            } else {
                p1Name = p1.getContext().getId();
                p2Name = p2.getContext().getId();
            }
            return p1Name.compareToIgnoreCase(p2Name);
        }
    };

    public InstanceContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public void setInstanceContainer(InstanceContainer instanceContainer) {
        this.instanceContainer = instanceContainer;
    }

    public AuthorizationDomainRegistry getAuthorizationDomainRegistry() {
        return this.authorizationDomainRegistry;
    }

    public void setAuthorizationDomainRegistry(AuthorizationDomainRegistry authorizationDomainRegistry) {
        this.authorizationDomainRegistry = authorizationDomainRegistry;
    }

    public RoleModule getRoleModule() {
        return this.roleModule;
    }

    public void setRoleModule(RoleModule roleModule) {
        this.roleModule = roleModule;
    }

    public FederatingPortletInvoker getFederatingPortletInvoker() {
        return this.federatingPortletInvoker;
    }

    public void setFederatingPortletInvoker(FederatingPortletInvoker federatingPortletInvoker) {
        this.federatingPortletInvoker = federatingPortletInvoker;
    }

    public int getPaginationSize() {
        return this.paginationSize;
    }

    public void setPaginationSize(int paginationSize) {
        this.paginationSize = paginationSize;
    }

    public int getSelectedFrom() {
        return this.selectedFrom;
    }

    public void setSelectedFrom(int selectedFrom) {
        this.selectedFrom = selectedFrom;
    }

    public String getSelectedPlugin() {
        return this.selectedPlugin;
    }

    public void setSelectedPlugin(String selectedPlugin) {
        this.selectedPlugin = selectedPlugin;
    }

    public String getSelectedPortletInvokerId() {
        return this.selectedPortletInvokerId;
    }

    public void setSelectedPortletInvokerId(String selectedPortletInvokerId) {
        this.selectedPortletInvokerId = selectedPortletInvokerId;
        this.selectedPortletId = null;
        this.selectedFrom = 0;
    }

    private PortletInvoker getSelectedPortletInvoker() {
        if (this.selectedPortletInvoker == null) {
            this.selectedPortletInvoker = this.federatingPortletInvoker.getFederatedInvoker(this.selectedPortletInvokerId);
        }
        return this.selectedPortletInvoker;
    }

    public Collection getPortletInvokerItems() {
        if (this.portletInvokerItems == null) {
            this.portletInvokerItems = new ArrayList();
            this.portletInvokerItems.add(new SelectItem((Object)"local"));
            for (FederatedPortletInvoker federated : this.federatingPortletInvoker.getFederatedInvokers()) {
                if ("local".equals(federated.getId())) continue;
                this.portletInvokerItems.add(new SelectItem((Object)federated.getId()));
            }
        }
        return this.portletInvokerItems;
    }

    public PreferencesBean getSelectedPreferences() {
        Portlet portlet = this.getSelectedPortlet();
        if (portlet != null) {
            PreferencesInfo prefsInfo = null;
            try {
                prefsInfo = portlet.getInfo().getPreferences();
            }
            catch (Exception e) {
                log.info((Object)("Couldn't retrieve preferences for portlet " + portlet.getContext().getId()), (Throwable)e);
            }
            if (prefsInfo != null) {
                this.selectedPreferences = new PreferencesBean(false);
                for (String key : prefsInfo.getKeys()) {
                    PreferenceInfo preferenceInfo = prefsInfo.getPreference(key);
                    this.selectedPreferences.addEntry(preferenceInfo);
                }
            }
        }
        return this.selectedPreferences;
    }

    private List getPortlets() {
        try {
            if (this.portlets == null) {
                this.portlets = new ArrayList();
                ArrayList tmpPortlets = null;
                tmpPortlets = this.getSelectedPortletInvoker() != null ? new ArrayList(this.getSelectedPortletInvoker().getPortlets()) : new ArrayList(this.federatingPortletInvoker.getFederatedInvoker("local").getPortlets());
                block2: for (Portlet portlet : tmpPortlets) {
                    PortletInfo info = portlet.getInfo();
                    for (ModeInfo modeInfo : info.getCapabilities().getAllModes()) {
                        if (!modeInfo.getMode().equals((Object)this.INTERNAL_EDIT_CONTENT)) continue;
                        continue block2;
                    }
                    this.portlets.add(portlet);
                }
                Collections.sort(this.portlets, this.comparator);
            }
            return this.portlets;
        }
        catch (PortletInvokerException e) {
            log.warn((Object)("Couldn't access portlet invoker. Portlets won't be listed.\nReason:\n\t" + e.getLocalizedMessage()));
            return Collections.EMPTY_LIST;
        }
    }

    public Collection getSelectedPortlets() {
        List portlets = this.getPortlets();
        int to = Math.min(this.selectedFrom + this.paginationSize, portlets.size());
        return portlets.subList(this.selectedFrom, to);
    }

    public int getPortletCount() {
        return this.getPortlets().size();
    }

    public DomainConfigurator getDomainConfigurator() {
        return this.authorizationDomainRegistry.getDomain("portlet").getConfigurator();
    }

    public Portlet getSelectedPortlet() {
        if (this.selectedPortlet == null && this.selectedPortletId != null && this.getSelectedPortletInvoker() != null) {
            try {
                this.selectedPortlet = this.getSelectedPortletInvoker().getPortlet(PortletContext.createPortletContext((String)this.selectedPortletId));
            }
            catch (PortletInvokerException e) {
                log.warn((Object)("Portlet invoker unavailable for portlet: " + this.selectedPortletId + ". Returning null instead.\nReason:\n\t" + e.getLocalizedMessage()));
            }
        }
        return this.selectedPortlet;
    }

    public String selectPortlet() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.selectedPortletId = (String)ctx.getExternalContext().getRequestParameterMap().get("id");
        this.selectedPlugin = (String)ctx.getExternalContext().getRequestParameterMap().get("plugin");
        this.selectedFrom = 0;
        if (this.selectedPortletId != null && this.selectedPortletId.length() != 0) {
            try {
                PortletContext portletCtx = PortletContext.createPortletContext((String)this.selectedPortletId);
                FederatedPortlet portlet = (FederatedPortlet)this.federatingPortletInvoker.getPortlet(portletCtx);
                this.selectedPortletInvokerId = portlet.getFederatedId();
                ArrayList portlets = new ArrayList(this.getSelectedPortletInvoker().getPortlets());
                Collections.sort(portlets, this.comparator);
                for (int i = 0; i < portlets.size(); ++i) {
                    Portlet current = (Portlet)portlets.get(i);
                    if (!portlet.getContext().getId().equals(current.getContext().getId())) continue;
                    this.selectedFrom = i / this.paginationSize * this.paginationSize;
                }
            }
            catch (PortletInvokerException e) {
                e.printStackTrace();
            }
        } else {
            this.selectedPortletId = null;
            this.selectedPortlet = null;
        }
        return "portlets";
    }

    public void selectFrom() {
        Map pmap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        this.selectedFrom = Integer.parseInt((String)pmap.get("from"));
        this.selectedPlugin = null;
        this.selectedPortletId = null;
    }

    public void refresh() {
        this.selectedPreferences = null;
        this.selectedPortlet = null;
        this.selectedPortletInvoker = null;
        this.portlets = null;
        this.portletInvokerItems = null;
    }

    static {
        Class<AdminPropertyResolver> clazz = AdminPropertyResolver.class;
        log.debug((Object)("Loaded bean decorator class " + clazz.getName()));
    }
}

