/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.actions;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import org.jboss.portal.common.i18n.LocaleFormat;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.util.ConversionException;
import org.jboss.portal.core.admin.ui.DisplayNameBean;
import org.jboss.portal.core.model.HasDisplayName;
import org.jboss.portal.faces.gui.ManagedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DisplayNameAction
extends ManagedBean {
    protected Object managerBean;
    protected String newLocale;
    protected String newText;
    protected DisplayNameBean displayNameBean;
    protected HasDisplayName target;
    protected static final String DISPLAY_NAME_TYPE = "DISPLAY_NAME_TYPE";

    public Object getManagerBean() {
        return this.managerBean;
    }

    public void setManagerBean(Object managerBean) {
        this.checkManagerBean(managerBean);
        this.managerBean = managerBean;
    }

    public String getNewText() {
        return this.newText;
    }

    public void setNewText(String newText) {
        this.newText = newText;
    }

    public SortedMap getLocales() {
        return this.getDisplayNameBean().getLocales();
    }

    public String getNewLocale() {
        return this.newLocale;
    }

    public void setNewLocale(String newLocale) {
        this.newLocale = newLocale;
    }

    public DisplayNameBean getDisplayNameBean() {
        if (this.displayNameBean == null) {
            this.displayNameBean = new DisplayNameBean();
        }
        return this.displayNameBean;
    }

    public void setDisplayNameBean(DisplayNameBean displayNameBean) {
        this.displayNameBean = displayNameBean;
    }

    public void addDisplayName() throws ConversionException {
        this.newText = this.checkNameValidity(this.newText, "display-names-view:add-display-name-form:newName");
        if (this.newText != null) {
            HasDisplayName hasDisplayName = this.getTarget();
            Map map = this.getDisplayNameBean().createLocalizedStringMap(LocaleFormat.DEFAULT.getLocale(this.newLocale), hasDisplayName.getDisplayName(), this.newText);
            LocalizedString newLocalizedString = new LocalizedString(map, Locale.ENGLISH);
            this.target.setDisplayName(newLocalizedString);
        }
    }

    public List<DisplayNameBean.Value> getCurrentLocales() {
        this.target = this.getTarget();
        if (this.target != null && this.target.getDisplayName() != null) {
            return this.getDisplayNameBean().populateCurrentLocales(this.target.getDisplayName().getValues());
        }
        return null;
    }

    public void editDisplayName() {
        String locale = this.beanContext.getParameter("locale");
        String editAction = this.beanContext.getParameter("editAction");
        this.target = this.getTarget();
        LocalizedString displayName = this.target.getDisplayName();
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        if (displayName != null) {
            Map oldMap = displayName.getValues();
            Collection values = oldMap.values();
            if (editAction.equals("delete")) {
                for (LocalizedString.Value value : values) {
                    if (value.getLocale().toString().equals(locale)) continue;
                    map.put(value.getLocale(), value.getString());
                }
            }
            if (editAction.equals("rename")) {
                for (LocalizedString.Value value : values) {
                    map.put(value.getLocale(), value.getString());
                    if (!value.getLocale().toString().equals(locale)) continue;
                    this.newText = value.getString();
                    this.newLocale = value.getLocale().getLanguage();
                }
            }
        }
        LocalizedString newLocalizedString = new LocalizedString(map, Locale.ENGLISH);
        this.target.setDisplayName(newLocalizedString);
    }

    public String editDisplayNames() throws ConversionException {
        this.getTarget();
        this.getCurrentLocales();
        return "editDisplayNames";
    }

    protected String getObjectTypeName() {
        return DISPLAY_NAME_TYPE;
    }

    public boolean isAlreadyExisting(String objectName) {
        return false;
    }

    protected abstract HasDisplayName getTarget();

    protected abstract void checkManagerBean(Object var1);
}

