/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller.command.mapper;

import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.command.mapper.AbstractCommandFactory;
import org.jboss.portal.core.controller.command.mapper.CommandFactory;
import org.jboss.portal.core.controller.command.mapper.DelegatingCommandFactory;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.server.servlet.PathMapping;
import org.jboss.portal.server.servlet.PathMappingResult;
import org.jboss.portal.server.servlet.PathParser;

public class DelegatingCommandFactoryService
extends AbstractCommandFactory
implements DelegatingCommandFactory {
    private PathParser parser;
    private CommandFactory nextFactory;
    private Map factories = new HashMap();
    private PathMapping mapping;

    public DelegatingCommandFactoryService() {
        this.parser = new PathParser();
        this.mapping = new PathMapping(){

            public Object getRoot() {
                return this;
            }

            public Object getChild(Object parent, String name) {
                if (parent == this) {
                    CommandFactory factory = (CommandFactory)DelegatingCommandFactoryService.this.factories.get(name);
                    if (factory != null) {
                        return factory;
                    }
                    return DelegatingCommandFactoryService.this.factories.get("");
                }
                return null;
            }
        };
    }

    public CommandFactory getNextFactory() {
        return this.nextFactory;
    }

    public void setNextFactory(CommandFactory nextFactory) {
        this.nextFactory = nextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String path, CommandFactory factory) {
        if (path == null) {
            throw new IllegalArgumentException("no path");
        }
        if (factory == null) {
            throw new IllegalArgumentException("no mapper");
        }
        DelegatingCommandFactoryService delegatingCommandFactoryService = this;
        synchronized (delegatingCommandFactoryService) {
            path = path.substring(1);
            if (this.factories.containsKey(path)) {
                throw new IllegalArgumentException("path already registered");
            }
            HashMap<String, CommandFactory> copy = new HashMap<String, CommandFactory>(this.factories);
            copy.put(path, factory);
            this.factories = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String path) {
        if (path == null) {
            throw new IllegalArgumentException("no path");
        }
        DelegatingCommandFactoryService delegatingCommandFactoryService = this;
        synchronized (delegatingCommandFactoryService) {
            path = path.substring(1);
            if (!this.factories.containsKey(path)) {
                throw new IllegalArgumentException("path not registered");
            }
            HashMap copy = new HashMap(this.factories);
            copy.remove(path);
            this.factories = copy;
        }
    }

    public ControllerCommand doMapping(ControllerContext controllerContext, ServerInvocation invocation, String host, String contextPath, String requestPath) {
        if (requestPath.length() == 0) {
            return null;
        }
        PathMappingResult result = this.parser.map(this.mapping, requestPath);
        Object target = result.getTarget();
        ControllerCommand cmd = null;
        if (target instanceof CommandFactory) {
            CommandFactory delegate = (CommandFactory)target;
            String remainingPath = result.getRemainingPath();
            cmd = delegate.doMapping(controllerContext, invocation, host, contextPath + result.getMatchedPath(), remainingPath);
        }
        if (cmd == null && this.nextFactory != null) {
            cmd = this.nextFactory.doMapping(controllerContext, invocation, host, contextPath, requestPath);
        }
        return cmd;
    }
}

