/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.apache.catalina.Context;
import org.jboss.aspects.patterns.observable.Observer;
import org.jboss.aspects.patterns.observable.Subject;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.aop.PojoCacheMBean;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.transaction.BatchModeTransactionManager;
import org.jboss.invocation.MarshalledValue;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.MarshalledValueOutputStream;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.web.tomcat.service.session.CacheListener;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.JBossCacheManager;
import org.jboss.web.tomcat.service.session.JBossCacheWrapper;
import org.jboss.web.tomcat.service.session.SessionReplicationContext;
import org.jboss.web.tomcat.service.session.Util;

public class JBossCacheService {
    protected static Logger log_ = Logger.getLogger(JBossCacheService.class);
    public static final String BUDDY_BACKUP = "_BUDDY_BACKUP_";
    public static final Fqn BUDDY_BACKUP_FQN = BuddyManager.BUDDY_BACKUP_SUBTREE_FQN;
    public static final String SESSION = "JSESSION";
    public static final String ATTRIBUTE = "ATTRIBUTE";
    public static final String VERSION_KEY = "VERSION";
    static final String FQN_DELIMITER = "/";
    private PojoCacheMBean proxy_;
    private String hostName_;
    private String webAppPath_;
    private TransactionManager tm;
    private JBossCacheManager manager_;
    private CacheListener cacheListener_;
    private JBossCacheWrapper cacheWrapper_;
    private boolean useTreeCacheMarshalling_ = false;
    private WeakHashMap typeMap = new WeakHashMap();

    private static PojoCacheMBean getPojoCacheMBean(String objectName) throws ClusteringNotSupportedException {
        try {
            ObjectName cacheServiceName = new ObjectName(objectName);
            return (PojoCacheMBean)MBeanProxyExt.create(PojoCacheMBean.class, (ObjectName)cacheServiceName);
        }
        catch (Throwable t) {
            String str = "Could not access TreeCache service " + (objectName == null ? "<null>" : objectName) + " for Tomcat clustering";
            log_.debug((Object)str);
            throw new ClusteringNotSupportedException(str, t);
        }
    }

    public JBossCacheService(PojoCacheMBean pojoCache) {
        this.proxy_ = pojoCache;
        this.cacheWrapper_ = new JBossCacheWrapper(this.proxy_);
        this.useTreeCacheMarshalling_ = this.proxy_.getUseRegionBasedMarshalling();
    }

    public JBossCacheService(String treeCacheObjectName) throws ClusteringNotSupportedException {
        this(JBossCacheService.getPojoCacheMBean(treeCacheObjectName));
    }

    public void start(ClassLoader tcl, JBossCacheManager manager) {
        this.manager_ = manager;
        Context webapp = (Context)this.manager_.getContainer();
        String path = webapp.getName();
        this.webAppPath_ = path.length() == 0 || path.equals(FQN_DELIMITER) ? "ROOT" : (path.startsWith(FQN_DELIMITER) ? path.substring(1) : path);
        this.webAppPath_ = this.webAppPath_.replace('/', '?');
        log_.debug((Object)("Old and new web app path are: " + path + ", " + this.webAppPath_));
        String host = webapp.getParent().getName();
        this.hostName_ = host == null || host.length() == 0 ? "localhost" : host;
        log_.debug((Object)("Old and new virtual host name are: " + host + ", " + this.hostName_));
        this.cacheListener_ = new CacheListener(this.cacheWrapper_, this.manager_, this.hostName_, this.webAppPath_);
        this.proxy_.addTreeCacheListener((TreeCacheListener)this.cacheListener_);
        Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_};
        Fqn pathFqn = new Fqn(objs);
        String fqnStr = pathFqn.toString();
        try {
            if (this.useTreeCacheMarshalling_) {
                log_.debug((Object)("UseMarshalling is true. We will register the fqn: " + fqnStr + " with class loader" + tcl + " and activate the webapp's Region"));
                this.proxy_.registerClassLoader(fqnStr, tcl);
                this.proxy_.activateRegion(fqnStr);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't register class loader", ex);
        }
        this.tm = this.proxy_.getTransactionManager();
        if (!(this.tm instanceof BatchModeTransactionManager)) {
            throw new RuntimeException("JBossCacheService.start(): JBossCacheAop transaction manager is not type BatchModeTransactionManager. Please check the tc5-cluster-service.xml TransactionManagerClassLookup field.");
        }
    }

    public void stop() {
        this.proxy_.removeTreeCacheListener((TreeCacheListener)this.cacheListener_);
        Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_};
        Fqn pathFqn = new Fqn(objs);
        String fqnStr = pathFqn.toString();
        if (this.useTreeCacheMarshalling_) {
            log_.debug((Object)("UseMarshalling is true. We will inactivate the fqn: " + fqnStr + " and un-register its classloader"));
            try {
                this.proxy_.inactivateRegion(fqnStr);
                this.proxy_.unregisterClassLoader(fqnStr);
            }
            catch (Exception e) {
                log_.error((Object)("Exception during inactivation of webapp region " + fqnStr + " or un-registration of its class loader"), (Throwable)e);
            }
        }
        this.cacheWrapper_.evictSubtree(pathFqn);
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public boolean isMarshallingAvailable() {
        return this.useTreeCacheMarshalling_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredSession loadSession(String realId, ClusteredSession toLoad) {
        Integer ver;
        Fqn fqn = this.getSessionFqn(realId);
        Object sessionData = this.cacheWrapper_.get(fqn, realId, true);
        if (sessionData == null) {
            return null;
        }
        boolean firstLoad = toLoad.getVersion() == 0;
        byte[] sessionBytes = (byte[])sessionData;
        ClassLoader prevTCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.manager_.getWebappClassLoader());
        try {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(sessionBytes);
                MarshalledValueInputStream input = new MarshalledValueInputStream((InputStream)bais);
                toLoad.readExternal((ObjectInput)input);
                input.close();
            }
            catch (Exception e) {
                log_.error((Object)("loadSession(): id: " + realId + " exception occurred during deserialization"), (Throwable)e);
                ClusteredSession clusteredSession = null;
                Object var11_13 = null;
                Thread.currentThread().setContextClassLoader(prevTCL);
                return clusteredSession;
            }
            Object var11_12 = null;
            Thread.currentThread().setContextClassLoader(prevTCL);
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            Thread.currentThread().setContextClassLoader(prevTCL);
            throw throwable;
        }
        if (firstLoad && (ver = (Integer)this.cacheWrapper_.get(fqn, VERSION_KEY)) != null) {
            toLoad.setVersion(ver);
        }
        return toLoad;
    }

    public void putSession(String realId, ClusteredSession session) {
        Fqn fqn = this.getSessionFqn(realId);
        if (session.getReplicateSessionBody()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(realId, this.externalizeSession(session));
            map.put(VERSION_KEY, new Integer(session.getVersion()));
            this.cacheWrapper_.put(fqn, map);
        } else {
            this.cacheWrapper_.put(fqn, VERSION_KEY, new Integer(session.getVersion()));
        }
    }

    public void removeSession(String realId) {
        Fqn fqn = this.getSessionFqn(realId);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("Remove session from distributed store. Fqn: " + fqn));
        }
        this.cacheWrapper_.remove(fqn, realId);
        this.cacheWrapper_.remove(fqn);
    }

    public void removeSessionLocal(String realId) {
        Fqn fqn = this.getSessionFqn(realId);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("Remove session from my own distributed store only. Fqn: " + fqn));
        }
        this.cacheWrapper_.evictSubtree(fqn);
    }

    public void removeSessionLocal(String realId, String dataOwner) {
        if (dataOwner == null) {
            this.removeSessionLocal(realId);
        } else {
            Fqn fqn = this.getSessionFqn(realId, dataOwner);
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("Remove session from my own distributed store only. Fqn: " + fqn));
            }
            this.cacheWrapper_.evictSubtree(fqn);
        }
    }

    public boolean exists(String realId) {
        Fqn fqn = this.getSessionFqn(realId);
        return this.proxy_.exists(fqn);
    }

    public Object getAttribute(String realId, String key) {
        Fqn fqn = this.getAttributeFqn(realId);
        return this.getUnMarshalledValue(this.cacheWrapper_.get(fqn, key));
    }

    public void putAttribute(String realId, String key, Object value) {
        Fqn fqn = this.getAttributeFqn(realId);
        this.cacheWrapper_.put(fqn, key, this.getMarshalledValue(value));
    }

    public void putAttribute(String realId, Map map) {
        HashMap marshalled = new HashMap(map.size());
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            marshalled.put(entry.getKey(), this.getMarshalledValue(entry.getValue()));
        }
        Fqn fqn = this.getAttributeFqn(realId);
        this.cacheWrapper_.put(fqn, marshalled);
    }

    public void removeAttributes(String realId) {
        Fqn fqn = this.getAttributeFqn(realId);
        this.cacheWrapper_.remove(fqn);
    }

    public Object removeAttribute(String realId, String key) {
        Fqn fqn = this.getAttributeFqn(realId);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("Remove attribute from distributed store. Fqn: " + fqn + " key: " + key));
        }
        return this.getUnMarshalledValue(this.cacheWrapper_.remove(fqn, key));
    }

    public void removeAttributesLocal(String realId) {
        Fqn fqn = this.getAttributeFqn(realId);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("Remove attributes from my own distributed store only. Fqn: " + fqn));
        }
        this.cacheWrapper_.evict(fqn);
    }

    public Set getAttributeKeys(String realId) {
        Set keys = null;
        Fqn fqn = this.getAttributeFqn(realId);
        try {
            keys = this.proxy_.getKeys(fqn);
        }
        catch (CacheException e) {
            log_.error((Object)("getAttributeKeys(): Exception getting keys for session " + realId), (Throwable)e);
        }
        return keys;
    }

    public Map getAttributes(String realId) {
        if (realId == null || realId.length() == 0) {
            return new HashMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set set = this.getAttributeKeys(realId);
        if (set != null) {
            for (String key : set) {
                Object value = this.getAttribute(realId, key);
                map.put(key, value);
            }
        }
        return map;
    }

    public Map getSessionIds() throws CacheException {
        HashMap result = new HashMap();
        Set owners = this.proxy_.getChildrenNames(BUDDY_BACKUP_FQN);
        if (owners != null) {
            for (Object owner : owners) {
                Set ids = this.proxy_.getChildrenNames(this.getWebappFqn(owner));
                this.storeSessionOwners(ids, owner, result);
            }
        }
        this.storeSessionOwners(this.proxy_.getChildrenNames(this.getWebappFqn()), null, result);
        return result;
    }

    private void storeSessionOwners(Set ids, Object owner, Map map) {
        if (ids != null) {
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                map.put(it.next(), owner);
            }
        }
    }

    public Object setPojo(String realId, String key, Object pojo) {
        Object object;
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("setPojo(): session id: " + realId + " key: " + key + " object: " + pojo.toString()));
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        try {
            SessionReplicationContext.startCacheActivity();
            object = this.proxy_.putObject(fqn, pojo);
            Object var7_7 = null;
        }
        catch (CacheException e) {
            try {
                throw new RuntimeException("JBossCacheService: exception occurred in cache setPojo ... ", e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                SessionReplicationContext.finishCacheActivity();
                throw throwable;
            }
        }
        SessionReplicationContext.finishCacheActivity();
        return object;
    }

    public Object removePojo(String realId, String key) {
        Object object;
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("removePojo(): session id: " + realId + " key: " + key));
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        try {
            SessionReplicationContext.startCacheActivity();
            object = this.proxy_.removeObject(fqn);
            Object var6_6 = null;
        }
        catch (CacheException e) {
            try {
                throw new RuntimeException("JBossCacheService: exception occurred in cache removePojo ... ", e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                SessionReplicationContext.finishCacheActivity();
                throw throwable;
            }
        }
        SessionReplicationContext.finishCacheActivity();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePojosLocal(String realId) {
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("removePojoLocal(): session id: " + realId));
        }
        Fqn fqn = this.getAttributeFqn(realId);
        try {
            SessionReplicationContext.startCacheActivity();
            this.cacheWrapper_.evictSubtree(fqn);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            SessionReplicationContext.finishCacheActivity();
            throw throwable;
        }
        SessionReplicationContext.finishCacheActivity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePojoLocal(String realId, String key) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("removePojoLocal(): session id: " + realId + " key: " + key));
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        try {
            SessionReplicationContext.startCacheActivity();
            this.cacheWrapper_.evictSubtree(fqn);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            SessionReplicationContext.finishCacheActivity();
            throw throwable;
        }
        SessionReplicationContext.finishCacheActivity();
    }

    public Set getPojoKeys(String realId) {
        Set keys = null;
        Fqn fqn = this.getAttributeFqn(realId);
        try {
            keys = this.proxy_.getChildrenNames(fqn);
        }
        catch (CacheException e) {
            log_.error((Object)("getPojoKeys(): Exception getting keys for session " + realId), (Throwable)e);
        }
        return keys;
    }

    public Object getPojo(String realId, String key) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("getPojo(): session id: " + realId + " key: " + key));
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        try {
            return this.proxy_.getObject(fqn);
        }
        catch (CacheException e) {
            throw new RuntimeException("JBossCacheService: exception occurred in cache getPojo ... ", e);
        }
    }

    public void addObserver(Observer session, Object pojo) {
        this.addObserver(session, pojo, new HashSet());
    }

    private void addObserver(Observer session, Object pojo, Set processed) {
        Class<?> type;
        Set complexFields;
        if (pojo instanceof Collection) {
            Collection col = (Collection)pojo;
            Iterator i = col.iterator();
            while (i.hasNext()) {
                this.addObserver(session, i.next(), processed);
            }
            return;
        }
        if (pojo instanceof Map) {
            for (Map.Entry entry : ((Map)pojo).entrySet()) {
                this.addObserver(session, entry.getKey(), processed);
                this.addObserver(session, entry.getValue(), processed);
            }
            return;
        }
        if (!(pojo instanceof Subject)) {
            return;
        }
        Subject subject = (Subject)pojo;
        subject.addObserver(session);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("addObserver(): session: " + session + " pojo name: " + pojo.getClass().getName()));
        }
        if ((complexFields = (Set)this.typeMap.get(type = pojo.getClass())) == null) {
            complexFields = Util.parseComplexFields(type);
            this.typeMap.put(type, complexFields);
        }
        if (complexFields.size() == 0) {
            return;
        }
        processed.add(pojo);
        block8: for (String fieldName : complexFields) {
            Class<?> curType = type;
            while (curType != null) {
                try {
                    Object var15_18;
                    Field field = curType.getDeclaredField(fieldName);
                    boolean accessible = field.isAccessible();
                    Object value = null;
                    try {
                        try {
                            field.setAccessible(true);
                            value = field.get(pojo);
                            if (value != null && !processed.contains(value)) {
                                this.addObserver(session, value, processed);
                            }
                            var15_18 = null;
                            field.setAccessible(accessible);
                            continue block8;
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("field access failed", e);
                        }
                    }
                    catch (Throwable throwable) {
                        var15_18 = null;
                        field.setAccessible(accessible);
                        throw throwable;
                    }
                }
                catch (NoSuchFieldException e) {
                    if ((curType = curType.getSuperclass()) != null) continue;
                    throw new RuntimeException("Field " + fieldName + " does not exist", e);
                }
            }
        }
    }

    public void removeObserver(Observer session, Object pojo) {
        this.removeObserver(session, pojo, new HashSet());
    }

    private void removeObserver(Observer session, Object pojo, Set stack) {
        Class<?> type;
        Set complexFields;
        if (pojo instanceof Collection) {
            Collection col = (Collection)pojo;
            for (Object obj : col) {
                this.removeObserver(session, obj, stack);
            }
            return;
        }
        if (pojo instanceof Map) {
            Map map = (Map)pojo;
            for (Object key : map.keySet()) {
                Object value = map.get(key);
                this.removeObserver(session, key, stack);
                this.removeObserver(session, value, stack);
            }
            return;
        }
        if (!(pojo instanceof Subject)) {
            return;
        }
        Subject subject = (Subject)pojo;
        subject.removeObserver(session);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("removeObserver(): session: " + session + " pojo name: " + pojo.getClass().getName()));
        }
        if ((complexFields = (Set)this.typeMap.get(type = pojo.getClass())) == null) {
            complexFields = Util.parseComplexFields(type);
            this.typeMap.put(type, complexFields);
        }
        if (complexFields.size() == 0) {
            return;
        }
        stack.add(pojo);
        block8: for (String fieldName : complexFields) {
            Class<?> curType = type;
            while (curType != null) {
                try {
                    Object var15_21;
                    Field field = curType.getDeclaredField(fieldName);
                    boolean accessible = field.isAccessible();
                    Object value = null;
                    try {
                        try {
                            field.setAccessible(true);
                            value = field.get(pojo);
                            if (value != null && !stack.contains(value)) {
                                this.removeObserver(session, value, stack);
                            }
                            var15_21 = null;
                            field.setAccessible(accessible);
                            continue block8;
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("field access failed", e);
                        }
                    }
                    catch (Throwable throwable) {
                        var15_21 = null;
                        field.setAccessible(accessible);
                        throw throwable;
                    }
                }
                catch (NoSuchFieldException e) {
                    if ((curType = curType.getSuperclass()) != null) continue;
                    throw new RuntimeException("Field " + fieldName + " does not exist", e);
                }
            }
        }
    }

    private Fqn getFieldFqn(String id, String key) {
        ArrayList<String> list = new ArrayList<String>(6);
        list.add(SESSION);
        list.add(this.hostName_);
        list.add(this.webAppPath_);
        list.add(id);
        list.add(ATTRIBUTE);
        this.breakKeys(key, list);
        return new Fqn(list);
    }

    private void breakKeys(String key, List list) {
        StringTokenizer token = new StringTokenizer(key, FQN_DELIMITER);
        while (token.hasMoreTokens()) {
            list.add(token.nextToken());
        }
    }

    private Fqn getWebappFqn() {
        Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_};
        return new Fqn(objs);
    }

    private Fqn getWebappFqn(Object dataOwner) {
        if (dataOwner == null) {
            return this.getWebappFqn();
        }
        Object[] objs = new Object[]{BUDDY_BACKUP, dataOwner, SESSION, this.hostName_, this.webAppPath_};
        return new Fqn(objs);
    }

    private Fqn getSessionFqn(String id) {
        Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_, id};
        return new Fqn(objs);
    }

    private Fqn getSessionFqn(String id, String dataOwner) {
        Object[] objs = new Object[]{BUDDY_BACKUP, dataOwner, SESSION, this.hostName_, this.webAppPath_, id};
        return new Fqn(objs);
    }

    private Fqn getAttributeFqn(String id) {
        Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_, id, ATTRIBUTE};
        return new Fqn(objs);
    }

    private Object getMarshalledValue(Object value) {
        try {
            MarshalledValue mv = new MarshalledValue(value);
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("marshalled object to size " + mv.size() + " bytes"));
            }
            return mv;
        }
        catch (IOException e) {
            log_.error((Object)"IOException occurred marshalling value ", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getUnMarshalledValue(Object mv) {
        if (mv == null) {
            return null;
        }
        ClassLoader prevTCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.manager_.getWebappClassLoader());
        try {
            try {
                Object object = ((MarshalledValue)mv).get();
                Object var6_6 = null;
                Thread.currentThread().setContextClassLoader(prevTCL);
                return object;
            }
            catch (IOException e) {
                log_.error((Object)"IOException occurred unmarshalling value ", (Throwable)e);
                Object var4_10 = null;
                Object var6_7 = null;
                Thread.currentThread().setContextClassLoader(prevTCL);
                return var4_10;
            }
            catch (ClassNotFoundException e) {
                log_.error((Object)"ClassNotFoundException occurred unmarshalling value ", (Throwable)e);
                Object var4_11 = null;
                Object var6_8 = null;
                Thread.currentThread().setContextClassLoader(prevTCL);
                return var4_11;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Thread.currentThread().setContextClassLoader(prevTCL);
            throw throwable;
        }
    }

    private byte[] externalizeSession(ClusteredSession session) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MarshalledValueOutputStream oos = new MarshalledValueOutputStream((OutputStream)baos);
            session.writeExternal((ObjectOutput)oos);
            oos.close();
            byte[] bytes = baos.toByteArray();
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("marshalled object to size " + bytes.length + " bytes"));
            }
            return bytes;
        }
        catch (Exception e) {
            log_.error((Object)("externalizeSession(): exception occurred externalizing session " + session), (Throwable)e);
            return null;
        }
    }
}

